package com.zehong.web.controller.deviceInspection;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TInspectionData;
import com.zehong.system.service.ITInspectionDataService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 巡检记录Controller
 * 
 * @author zehong
 * @date 2021-07-09
 */
@RestController
@RequestMapping("/deviceInspection/inspectionData")
public class TInspectionDataController extends BaseController
{
    @Autowired
    private ITInspectionDataService tInspectionDataService;

    /**
     * 查询巡检记录列表
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspectionData:list')")
    @GetMapping("/list")
    public TableDataInfo list(TInspectionData tInspectionData)
    {
        startPage();
        List<TInspectionData> list = tInspectionDataService.selectTInspectionDataList(tInspectionData);
        return getDataTable(list);
    }

    /**
     * 导出巡检记录列表
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspectionData:export')")
    @Log(title = "巡检记录", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TInspectionData tInspectionData)
    {
        List<TInspectionData> list = tInspectionDataService.selectTInspectionDataList(tInspectionData);
        ExcelUtil<TInspectionData> util = new ExcelUtil<TInspectionData>(TInspectionData.class);
        return util.exportExcel(list, "巡检记录数据");
    }

    /**
     * 获取巡检记录详细信息
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspectionData:query')")
    @GetMapping(value = "/{dataId}")
    public AjaxResult getInfo(@PathVariable("dataId") Long dataId)
    {
        return AjaxResult.success(tInspectionDataService.selectTInspectionDataById(dataId));
    }

    /**
     * 新增巡检记录
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspectionData:add')")
    @Log(title = "巡检记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TInspectionData tInspectionData)
    {
        return toAjax(tInspectionDataService.insertTInspectionData(tInspectionData));
    }

    /**
     * 修改巡检记录
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspectionData:edit')")
    @Log(title = "巡检记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TInspectionData tInspectionData)
    {
        return toAjax(tInspectionDataService.updateTInspectionData(tInspectionData));
    }

    /**
     * 删除巡检记录
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspectionData:remove')")
    @Log(title = "巡检记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{dataIds}")
    public AjaxResult remove(@PathVariable Long[] dataIds)
    {
        return toAjax(tInspectionDataService.deleteTInspectionDataByIds(dataIds));
    }
}
