import { Message } from 'element-ui';

// 提交通用
export const submitForm = async (run, params) => {
  const hide = Message.loading("正在提交", 1);
  try {
    hide.close()
    const res = await run(params);
    // console.log(res.code);
    // console.log("res99",res)
    if (res.code === 200) {
      if (res.data === -1) {
        Message.error(res.message);
        return false;
      }
      Message.success(res.message);
      return true;
    }
    return false;
  } catch (error) {
    hide.close();
    Message.error("提交失败,请重试！");
    return false;
  }
};