import request from '@/utils/request'

// 查询工单反馈信息列表
export function listFeedback(query) {
  return request({
    url: '/workOrder/feedback/list',
    method: 'get',
    params: query
  })
}

// 查询工单反馈信息详细
export function getFeedback(feedbackId) {
  return request({
    url: '/workOrder/feedback/' + feedbackId,
    method: 'get'
  })
}

// 新增工单反馈信息
export function addFeedback(data) {
  return request({
    url: '/workOrder/feedback',
    method: 'post',
    data: data
  })
}

// 修改工单反馈信息
export function updateFeedback(data) {
  return request({
    url: '/workOrder/feedback',
    method: 'put',
    data: data
  })
}

// 删除工单反馈信息
export function delFeedback(feedbackId) {
  return request({
    url: '/workOrder/feedback/' + feedbackId,
    method: 'delete'
  })
}

// 导出工单反馈信息
export function exportFeedback(query) {
  return request({
    url: '/workOrder/feedback/export',
    method: 'get',
    params: query
  })
}