import request from '@/utils/request'

// 查询巡检签到列表
export function listCheckIn(query) {
  return request({
    url: '/patorl/checkIn/list',
    method: 'get',
    params: query
  })
}

// 查询巡检签到详细
export function getCheckIn(chenckInId) {
  return request({
    url: '/patorl/checkIn/' + chenckInId,
    method: 'get'
  })
}

// 新增巡检签到
export function addCheckIn(data) {
  return request({
    url: '/patorl/checkIn',
    method: 'post',
    data: data
  })
}

// 修改巡检签到
export function updateCheckIn(data) {
  return request({
    url: '/patorl/checkIn',
    method: 'put',
    data: data
  })
}

// 删除巡检签到
export function delCheckIn(chenckInId) {
  return request({
    url: '/patorl/checkIn/' + chenckInId,
    method: 'delete'
  })
}

// 导出巡检签到
export function exportCheckIn(query) {
  return request({
    url: '/patorl/checkIn/export',
    method: 'get',
    params: query
  })
}
