import request from '@/utils/request'

// 查询巡检员定位列表
export function listLocation(query) {
  return request({
    url: '/system/location/list',
    method: 'get',
    params: query
  })
}

//初始化巡检员位置及路线
export function getInspectorLocations(query){
  return request({
    url: '/system/location/getInspectorLocations',
    method: 'get',
    params: query
  })
}

// 查询巡检员定位详细
export function getLocation(locationId) {
  return request({
    url: '/system/location/' + locationId,
    method: 'get'
  })
}

// 新增巡检员定位
export function addLocation(data) {
  return request({
    url: '/system/location',
    method: 'post',
    data: data
  })
}

// 修改巡检员定位
export function updateLocation(data) {
  return request({
    url: '/system/location',
    method: 'put',
    data: data
  })
}

// 删除巡检员定位
export function delLocation(locationId) {
  return request({
    url: '/system/location/' + locationId,
    method: 'delete'
  })
}

// 导出巡检员定位
export function exportLocation(query) {
  return request({
    url: '/system/location/export',
    method: 'get',
    params: query
  })
}
