/*
 * @Author: your name
 * @Date: 2021-07-16 10:06:43
 * @LastEditTime: 2022-01-18 11:36:15
 * @LastEditors: your name
 * @Description: 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 * @FilePath: /gassafety-web/src/api/enterprise/info.js
 */
import request from '@/utils/request'

// 查询企业基本信息列表
export function listInfo(query) {
  return request({
    url: '/enterprise/info/list',
    method: 'get',
    params: query
  })
}

// 查询企业基本信息详细
export function getInfo(infoId) {
  return request({
    url: '/enterprise/info/' + infoId,
    method: 'get'
  })
}

// 新增企业基本信息
export function addInfo(data) {
  return request({
    url: '/enterprise/info',
    method: 'post',
    data: data
  })
}

// 修改企业基本信息
export function updateInfo(data) {
  return request({
    url: '/enterprise/info',
    method: 'put',
    data: data
  })
}

// 删除企业基本信息
export function delInfo(infoId) {
  return request({
    url: '/enterprise/info/' + infoId,
    method: 'delete'
  })
}

// 导出企业基本信息
export function exportInfo(query) {
  return request({
    url: '/enterprise/info/export',
    method: 'get',
    params: query
  })
}

// 消除警报
export function handEliminationAlarm(query) {
  return request({
    url: 'dataMonitoring/deviceAlarm/handEliminationAlarm',
    method: 'get',
    params: query
  })
}
