import request from '@/utils/request'

// 查询巡检记录列表
export function listInspectionData(query) {
  return request({
    url: '/deviceInspection/inspectionData/list',
    method: 'get',
    params: query
  })
}

// 查询所有巡检记录不分页
export function getAllTInspectionInfo(query) {
  return request({
    url: '/deviceInspection/inspectionData/getAllTInspectionInfo',
    method: 'get',
    params: query
  })
}

// 查询巡检记录详细
export function getInspectionData(dataId) {
  return request({
    url: '/deviceInspection/inspectionData/' + dataId,
    method: 'get'
  })
}

// 新增巡检记录
export function addInspectionData(data) {
  return request({
    url: '/deviceInspection/inspectionData',
    method: 'post',
    data: data
  })
}

// 修改巡检记录
export function updateInspectionData(data) {
  return request({
    url: '/deviceInspection/inspectionData',
    method: 'put',
    data: data
  })
}

// 删除巡检记录
export function delInspectionData(dataId) {
  return request({
    url: '/deviceInspection/inspectionData/' + dataId,
    method: 'delete'
  })
}

// 导出巡检记录
export function exportInspectionData(query) {
  return request({
    url: '/deviceInspection/inspectionData/export',
    method: 'get',
    params: query
  })
}
