import request from '@/utils/request'

// 查询设备监控列表
export function listData(query) {
  return request({
    url: '/dataMonitoring/reportData/list',
    method: 'get',
    params: query
  })
}

// 查询设备监控实时列表
export function realtimeData(query) {
  return request({
    url: '/dataMonitoring/reportData/realtimeList',
    method: 'get',
    params: query
  })
}

// 查询设备监控详细
export function getData(deviceId) {
  return request({
    url: '/dataMonitoring/reportData/' + deviceId,
    method: 'get'
  })
}

// 查询设备监控详细
export function getWindowData(deviceId) {
  return request({
    url: '/dataMonitoring/reportData/getWindowData/' + deviceId,
    method: 'get'
  })
}

// 新增设备监控
export function addData(data) {
  return request({
    url: '/dataMonitoring/data',
    method: 'post',
    data: data
  })
}

// 修改设备监控
export function updateData(data) {
  return request({
    url: '/dataMonitoring/data',
    method: 'put',
    data: data
  })
}

// 删除设备监控
export function delData(deviceReportDataId) {
  return request({
    url: '/dataMonitoring/reportData/' + deviceReportDataId,
    method: 'delete'
  })
}

// 导出设备监控
export function exportData(query) {
  return request({
    url: '/dataMonitoring/reportData/export',
    method: 'get',
    params: query
  })
}
