package com.zehong.system.service.impl;

import java.util.List;

import com.github.pagehelper.PageInfo;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TMonitorDeviceMapper;
import com.zehong.system.domain.TMonitorDevice;
import com.zehong.system.service.ITMonitorDeviceService;

/**
 * 设备监控Service业务层处理
 * 
 * @author zehong
 * @date 2021-08-05
 */
@Service
public class TMonitorDeviceServiceImpl implements ITMonitorDeviceService 
{
    @Autowired
    private TMonitorDeviceMapper tMonitorDeviceMapper;

    /**
     * 查询设备监控
     * 
     * @param monitorId 设备监控ID
     * @return 设备监控
     */
    @Override
    public TMonitorDevice selectTMonitorDeviceById(Long monitorId)
    {
        return tMonitorDeviceMapper.selectTMonitorDeviceById(monitorId);
    }

    /**
     * 查询设备监控列表
     * 
     * @param tMonitorDevice 设备监控
     * @return 设备监控
     */
    @Override
    public List<TMonitorDevice> selectTMonitorDeviceList(TMonitorDevice tMonitorDevice)
    {
        return tMonitorDeviceMapper.selectTMonitorDeviceList(tMonitorDevice);
    }

    /**
     * 查询设备监控列表
     *
     * @param tMonitorDevice 设备监控
     * @return 设备监控
     */
    @Override
    public PageInfo<TMonitorDevice> selectTMonitorDevicePage(TMonitorDevice tMonitorDevice)
    {
        return new PageInfo(tMonitorDeviceMapper.selectTMonitorDeviceList(tMonitorDevice));
    }

    /**
     * 新增设备监控
     * 
     * @param tMonitorDevice 设备监控
     * @return 结果
     */
    @Override
    public int insertTMonitorDevice(TMonitorDevice tMonitorDevice)
    {
        tMonitorDevice.setCreateTime(DateUtils.getNowDate());
        return tMonitorDeviceMapper.insertTMonitorDevice(tMonitorDevice);
    }

    /**
     * 修改设备监控
     * 
     * @param tMonitorDevice 设备监控
     * @return 结果
     */
    @Override
    public int updateTMonitorDevice(TMonitorDevice tMonitorDevice)
    {
        tMonitorDevice.setUpdateTime(DateUtils.getNowDate());
        return tMonitorDeviceMapper.updateTMonitorDevice(tMonitorDevice);
    }

    /**
     * 批量删除设备监控
     * 
     * @param monitorIds 需要删除的设备监控ID
     * @return 结果
     */
    @Override
    public int deleteTMonitorDeviceByIds(Long[] monitorIds)
    {
        return tMonitorDeviceMapper.deleteTMonitorDeviceByIds(monitorIds);
    }

    /**
     * 删除设备监控信息
     * 
     * @param monitorId 设备监控ID
     * @return 结果
     */
    @Override
    public int deleteTMonitorDeviceById(Long monitorId)
    {
        return tMonitorDeviceMapper.deleteTMonitorDeviceById(monitorId);
    }
}
