package com.zehong.system.service.impl;

import com.github.pagehelper.PageInfo;
import com.zehong.system.domain.DeviceStatistics;
import com.zehong.system.mapper.DeviceStatisticsMapper;
import com.zehong.system.service.DeviceStatisticsService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 *  设备流量统计
 * @author gengd
 */

@Service
public class DeviceStatisticsServiceImpl implements DeviceStatisticsService {

    @Resource
    private DeviceStatisticsMapper deviceStatisticsMapper;

    /**
     * 根据统计时间获取开始标况累计流量
     * @param deviceStatistics
     * @return
     */
    @Override
    public List<DeviceStatistics> getDeviceStartStandardConditionAccumulation(DeviceStatistics deviceStatistics) {
        return deviceStatisticsMapper.getDeviceStartStandardConditionAccumulation(deviceStatistics);
    }

    /**
     * 根据统计时间获取结束标况累计流量
     * @param deviceStatistics
     * @return
     */
    @Override
    public PageInfo<DeviceStatistics> getDeviceEndStandardConditionAccumulation(DeviceStatistics deviceStatistics) {
        return new PageInfo(deviceStatisticsMapper.getDeviceEndStandardConditionAccumulation(deviceStatistics));
    }
}
