package com.zehong.system.service;

import java.util.List;
import java.util.Map;

import com.github.pagehelper.PageInfo;
import com.zehong.system.domain.EquipmentForm;
import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.domain.TDeviceInformation;
import com.zehong.system.domain.vo.DeviceInfoVo;

/**
 * 设备信息Service接口
 *
 * @author zehong
 * @date 2021-07-09
 */
public interface ITDeviceInfoService
{
    /**
     * 查询设备信息
     *
     * @param deviceId 设备信息ID
     * @return 设备信息
     */
    public DeviceInfoVo selectTDeviceInfoById(int deviceId);

    /**
     * 查询设备信息列表
     *
     * @param tDeviceInfo 设备信息
     * @return 设备信息集合
     */
    public List<DeviceInfoVo> selectTDeviceInfoList(TDeviceInfo tDeviceInfo);

    /**
     * 查询设备信息列表
     *
     * @param tDeviceInfo 设备信息
     * @return 设备信息集合
     */
    public PageInfo<DeviceInfoVo> selectTDeviceInfoPage(TDeviceInfo tDeviceInfo);

    /**
     * 构建前端所需要下拉树结构
     *
     * @param param 参数集合
     * @return 下拉树结构列表
     */
    public List<Map<Object, Object>> buildDeviceTreeSelect(Map<Object, List> param);

    /**
     * 设备树
     *
     * @param
     * @return 树结构列表
     */
    public List<Map<Object, Object>> buildDeviceTree() throws Exception;

    /**
     * 统计各设备类型的设备总数
     * @return
     */
    public List<Map<Object, Object>> countDeviceByType();

    /**
     * 新增设备信息
     *
     * @param tDeviceInfo 设备信息
     * @return 结果
     */
    public int insertTDeviceInfo(TDeviceInfo tDeviceInfo);

    /**
     * 修改设备信息
     *
     * @param tDeviceInfo 设备信息
     * @return 结果
     */
    public int updateTDeviceInfo(TDeviceInfo tDeviceInfo);

    /**
     * 批量删除设备信息
     *
     * @param deviceIds 需要删除的设备信息ID
     * @return 结果
     */
    public int deleteTDeviceInfoByIds(int[] deviceIds);

    /**
     * 删除设备信息信息
     *
     * @param deviceId 设备信息ID
     * @return 结果
     */
    public int deleteTDeviceInfoById(int deviceId);

    /**
     *
     * @return
     */
    public List<Map<String,Object>> devicefeed(Map<String, Object> param);

    /**
     * 查询下级设备所有信息
     * @param relationDeviceId
     * @return
     */
    List<EquipmentForm> selectDevice(int relationDeviceId);

    /**
     * 新增下级设备信息
     * @param equipmentList
     */
    void insertEquipmentList(List<EquipmentForm> equipmentList,int devid);

    /**
     * 删除下级设备信息
     * @param equipmentList
     */
    void deleteEquipmentList(List<EquipmentForm> equipmentList,int devid);

    /**
     * 根据设备id查询最新的设备信息数据
     * @param deviceId
     */
     List<TDeviceInformation> getInformations(int deviceId);
}
