package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TPatrolCheckIn;

/**
 * 巡检签到Mapper接口
 * 
 * @author zehong
 * @date 2023-03-02
 */
public interface TPatrolCheckInMapper 
{
    /**
     * 查询巡检签到
     * 
     * @param chenckInId 巡检签到ID
     * @return 巡检签到
     */
    public TPatrolCheckIn selectTPatrolCheckInById(Long chenckInId);

    /**
     * 查询巡检签到列表
     * 
     * @param tPatrolCheckIn 巡检签到
     * @return 巡检签到集合
     */
    public List<TPatrolCheckIn> selectTPatrolCheckInList(TPatrolCheckIn tPatrolCheckIn);

    /**
     * 新增巡检签到
     * 
     * @param tPatrolCheckIn 巡检签到
     * @return 结果
     */
    public int insertTPatrolCheckIn(TPatrolCheckIn tPatrolCheckIn);

    /**
     * 修改巡检签到
     * 
     * @param tPatrolCheckIn 巡检签到
     * @return 结果
     */
    public int updateTPatrolCheckIn(TPatrolCheckIn tPatrolCheckIn);

    /**
     * 删除巡检签到
     * 
     * @param chenckInId 巡检签到ID
     * @return 结果
     */
    public int deleteTPatrolCheckInById(Long chenckInId);

    /**
     * 批量删除巡检签到
     * 
     * @param chenckInIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTPatrolCheckInByIds(Long[] chenckInIds);
}
