package com.zehong.system.mapper;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.EquipmentForm;
import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.domain.TDeviceInformation;
import org.apache.commons.math3.analysis.function.Add;
import org.apache.ibatis.annotations.Param;

import javax.validation.Valid;

/**
 * 设备信息Mapper接口
 *
 * @author zehong
 * @date 2021-07-09
 */
public interface TDeviceInfoMapper
{
    /**
     * 查询设备信息
     *
     * @param deviceId 设备信息ID
     * @return 设备信息
     */
    public TDeviceInfo selectTDeviceInfoById(int deviceId);

    /**
     * 查询设备信息
     *
     * @param pipeId 管道ID
     * @return 设备信息
     */
    public List<TDeviceInfo> selectTDeviceInfoByPipeId(int pipeId);

    /**
     * 查询设备信息列表
     *
     * @param tDeviceInfo 设备信息
     * @return 设备信息集合
     */
    public List<TDeviceInfo> selectTDeviceInfoList(TDeviceInfo tDeviceInfo);

    /**
     * 统计各设备类型的设备总数
     * @return
     */
    public List<Map<Object, Object>> countDeviceByType();

    /**
     * 新增设备信息
     *
     * @param tDeviceInfo 设备信息
     * @return 结果
     */
    public int insertTDeviceInfo(TDeviceInfo tDeviceInfo);

    /**
     * 修改设备信息
     *
     * @param tDeviceInfo 设备信息
     * @return 结果
     */
    public int updateTDeviceInfo(TDeviceInfo tDeviceInfo);

    /**
     * 删除设备信息
     *
     * @param deviceId 设备信息ID
     * @return 结果
     */
    public int deleteTDeviceInfoById(int deviceId);

    /**
     * 批量删除设备信息
     *
     * @param deviceIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTDeviceInfoByIds(int[] deviceIds);

    /**
     * 工单设备进程
     */
    List<Map<String,Object>> selectdevicefeed(@Param("orderId") String orderId,
                                              @Param("ids") List<Integer> ids,
                                              @Param("ids2") List<Integer> ids2);

    /**
     * 添加下级设备
     * @param equipmentList
     */
    void insertTrelation(List<EquipmentForm> equipmentList);

    /**
     * 查询下级设备所有信息
     * @return
     */
    List<EquipmentForm> selectDevice(int relationDeviceId);


    /**
     * 删除下级设备信息
     * @param equipmentList
     */
    void deleteEquipmentList(@Param("list") List<EquipmentForm> equipmentList, @Param("devids") int devid);

    /**
     * 根据设备id查询最新的设备信息数据
     * @param deviceId
     * @return
     */
    List<TDeviceInformation> getInformation(int deviceId);
}
