package com.zehong.system.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.core.domain.BaseEntity;
import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.domain.TDeviceReportData;
import com.zehong.system.domain.TPipe;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 报警信息对象 t_device_alarm
 * 
 * @author zehong
 * @date 2021-07-21
 */
public class DeviceAlarmVo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Integer alarmId;

    /** 设备id */
    private Integer deviceId;

    /** 设备类型（0管道，1调压阀，2阀门井，3流量计，4压力表） */
    private String deviceType;

    /** 设备名称 */
    private String deviceName;

    /** 设备编号 */
    private String deviceCode;

    /** 设备监控数据列表（用于详情折线图） */
    private List<TDeviceReportData> deviceReportDataList;

    /** 设备列表（用于展示设备详情） */
    private List<TDeviceInfo> deviceList;

    /** 管道列表（用于展示管道详情） */
    private List<TPipe> pipeList;

    /** 工单id */
    private String orderId;

    /** 报警类型 */
    private String alarmType;

    /** 报警值（报警信息） */
    private String alarmValue;

    /** 报警开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    /** 报警结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /** 处理状态（1不需处理，2已处理完成，3未处理完成） */
    private String dealStatus;

    public void setAlarmId(Integer alarmId)
    {
        this.alarmId = alarmId;
    }

    public Integer getAlarmId()
    {
        return alarmId;
    }

    public void setDeviceId(Integer deviceId)
    {
        this.deviceId = deviceId;
    }

    public Integer getDeviceId()
    {
        return deviceId;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getDeviceName() {
        return deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getDeviceCode() {
        return deviceCode;
    }

    public void setDeviceCode(String deviceCode) {
        this.deviceCode = deviceCode;
    }

    public List<TDeviceReportData> getDeviceReportDataList() {
        return deviceReportDataList;
    }

    public void setDeviceReportDataList(List<TDeviceReportData> deviceReportDataList) {
        this.deviceReportDataList = deviceReportDataList;
    }

    public List<TDeviceInfo> getDeviceList() {
        return deviceList;
    }

    public void setDeviceList(List<TDeviceInfo> deviceList) {
        this.deviceList = deviceList;
    }

    public List<TPipe> getPipeList() {
        return pipeList;
    }

    public void setPipeList(List<TPipe> pipeList) {
        this.pipeList = pipeList;
    }

    public void setOrderId(String orderId)
    {
        this.orderId = orderId;
    }

    public String getOrderId() 
    {
        return orderId;
    }

    public void setAlarmType(String alarmType) 
    {
        this.alarmType = alarmType;
    }

    public String getAlarmType() 
    {
        return alarmType;
    }

    public void setAlarmValue(String alarmValue) 
    {
        this.alarmValue = alarmValue;
    }

    public String getAlarmValue() 
    {
        return alarmValue;
    }

    public void setStartTime(Date startTime) 
    {
        this.startTime = startTime;
    }

    public Date getStartTime() 
    {
        return startTime;
    }

    public void setEndTime(Date endTime) 
    {
        this.endTime = endTime;
    }

    public Date getEndTime() 
    {
        return endTime;
    }

    public void setDealStatus(String dealStatus) 
    {
        this.dealStatus = dealStatus;
    }

    public String getDealStatus() 
    {
        return dealStatus;
    }

    @Override
    public String toString() {
        return "DeviceAlarmVo{" +
                "alarmId=" + alarmId +
                ", deviceId=" + deviceId +
                ", deviceType='" + deviceType + '\'' +
                ", orderId='" + orderId + '\'' +
                ", alarmType='" + alarmType + '\'' +
                ", alarmValue='" + alarmValue + '\'' +
                ", startTime=" + startTime +
                ", endTime=" + endTime +
                ", dealStatus='" + dealStatus + '\'' +
                '}';
    }
}
