package com.zehong.web.controller.dataMonitoring;

import java.util.List;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.zehong.system.domain.form.DeviceAlarmForm;
import com.zehong.system.domain.vo.DeviceAlarmVo;
import com.zehong.system.service.WebSocketServer;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TDeviceAlarm;
import com.zehong.system.service.ITDeviceAlarmService;

/**
 * 报警信息Controller
 * 
 * @author zehong
 * @date 2021-07-21
 */
@RestController
@RequestMapping("/dataMonitoring/deviceAlarm")
public class TDeviceAlarmController extends BaseController
{
    @Autowired
    private ITDeviceAlarmService tDeviceAlarmService;

    @Autowired
    private WebSocketServer webSocketServer;


    /**
     * 查询报警信息列表
     */
    //@PreAuthorize("@ss.hasPermi('dataMonitoring:deviceAlarm:list')")
    @GetMapping("/list")
    public TableDataInfo list(DeviceAlarmForm deviceAlarmForm) throws Exception
    {
        startPage();
        PageInfo<DeviceAlarmVo> page = null;
        try {
            page = tDeviceAlarmService.selectTDeviceAlarmPage(deviceAlarmForm);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Exception("查询报警信息列表出错");
        }
        return getDataTable(page);
    }

    /**
     * 获取报警信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('dataMonitoring:deviceAlarm:query')")
    @GetMapping(value = "/{alarmId}")
    public AjaxResult getInfo(@PathVariable("alarmId") int alarmId) throws Exception
    {
        DeviceAlarmVo deviceAlarmVo = null;
        try {
            deviceAlarmVo = tDeviceAlarmService.selectTDeviceAlarmById(alarmId);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Exception("获取报警信息详细信息出错");
        }
        return AjaxResult.success(deviceAlarmVo);
    }

    /**
     * 新增报警信息
     */
    @PreAuthorize("@ss.hasPermi('dataMonitoring:deviceAlarm:add')")
    @Log(title = "报警信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TDeviceAlarm tDeviceAlarm)
    {
        return toAjax(tDeviceAlarmService.insertTDeviceAlarm(tDeviceAlarm));
    }

    /**
     * 修改报警信息
     */
    @PreAuthorize("@ss.hasPermi('dataMonitoring:deviceAlarm:edit')")
    @Log(title = "报警信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TDeviceAlarm tDeviceAlarm)
    {
        return toAjax(tDeviceAlarmService.updateTDeviceAlarm(tDeviceAlarm));
    }

    /**
     * 删除报警信息
     */
    @PreAuthorize("@ss.hasPermi('dataMonitoring:deviceAlarm:remove')")
    @Log(title = "报警信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{alarmIds}")
    public AjaxResult remove(@PathVariable int[] alarmIds)
    {
        return toAjax(tDeviceAlarmService.deleteTDeviceAlarmByIds(alarmIds));
    }

    /**
     * 查询报警设备
     * @return TDeviceAlarm
     */
    @GetMapping("selectAlarmDevice")
    public List<TDeviceAlarm> selectAlarmDevice (){
        return tDeviceAlarmService.selectAlarmDevice();
    }

    /**
     * 手动消警
     * @param alarmId 报警信息id
     * @return
     */
    @GetMapping("/handEliminationAlarm")
    public AjaxResult handEliminationAlarm(@RequestParam(value = "alarmId") int alarmId){
        try {
            TDeviceAlarm alarmVo = new TDeviceAlarm();
            alarmVo.setAlarmId(alarmId);
            alarmVo.setDealStatus("4");
            int status = tDeviceAlarmService.updateTDeviceAlarm(alarmVo);
            if(1 != status){
                throw new Exception("手动消警更新失败！");
            }
            DeviceAlarmVo alarm = tDeviceAlarmService.selectTDeviceAlarmById(alarmId);
            webSocketServer.batchSendMessage(JSONObject.toJSONString(alarm));
            return AjaxResult.success(alarm);
        } catch (Exception e) {
            logger.error("手动消警系统报错："+e);
        }
        return AjaxResult.error();
    }
}
