package com.zehong.web.controller.dataMonitoring;

import com.github.pagehelper.PageInfo;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.system.domain.DeviceStatistics;
import com.zehong.system.service.DeviceStatisticsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

@RestController
@RequestMapping("/dataMonitoring/deviceStatistics")
public class DeviceStatisticsContorller extends BaseController {

    @Autowired
    private DeviceStatisticsService deviceStatisticsService;

    @GetMapping("/getDeviceStatisticsInfo")
    public TableDataInfo getDeviceStatisticsInfo(DeviceStatistics deviceStatistics){

        if(null == deviceStatistics.getStartTime()){
            Calendar startTime = Calendar.getInstance();
            startTime.add(Calendar.DATE, - 7);
            deviceStatistics.setStartTime(startTime.getTime());
        }

        if(null == deviceStatistics.getEndTime()){
            deviceStatistics.setEndTime(new Date());

        }
        startPage();
        //设备统计结束时间累计流量
        PageInfo<DeviceStatistics> deviceStatisticsEndListInfo = deviceStatisticsService.getDeviceEndStandardConditionAccumulation(deviceStatistics);
        //设备统计开始时间累计流量
        List<DeviceStatistics> deviceStatisticsStartListInfo = deviceStatisticsService.getDeviceStartStandardConditionAccumulation(deviceStatistics);
        for(DeviceStatistics deviceStatisticsEndInfo : deviceStatisticsEndListInfo.getList()){
            for(DeviceStatistics deviceStatisticsStartInfo : deviceStatisticsStartListInfo){
                if(deviceStatisticsEndInfo.getDeviceNum().equals(deviceStatisticsStartInfo.getDeviceNum())){
                    deviceStatisticsEndInfo.setStartTime(deviceStatisticsStartInfo.getStartTime());
                    deviceStatisticsEndInfo.setStandardConditionAccumulation(deviceStatisticsEndInfo.getStandardConditionAccumulation().subtract(deviceStatisticsStartInfo.getStandardConditionAccumulation()));
                }
            }
        }
        return getDataTable(deviceStatisticsEndListInfo);
    }
}
