package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.THiddenTrouble;

/**
 * 隐患信息Mapper接口
 * 
 * @author zehong
 * @date 2021-07-21
 */
public interface THiddenTroubleMapper 
{
    /**
     * 查询隐患信息
     * 
     * @param troubleId 隐患信息ID
     * @return 隐患信息
     */
    public THiddenTrouble selectTHiddenTroubleById(int troubleId);

    /**
     * 查询隐患信息列表
     * 
     * @param tHiddenTrouble 隐患信息
     * @return 隐患信息集合
     */
    public List<THiddenTrouble> selectTHiddenTroubleList(THiddenTrouble tHiddenTrouble);

    /**
     * 新增隐患信息
     * 
     * @param tHiddenTrouble 隐患信息
     * @return 结果
     */
    public int insertTHiddenTrouble(THiddenTrouble tHiddenTrouble);

    /**
     * 修改隐患信息
     * 
     * @param tHiddenTrouble 隐患信息
     * @return 结果
     */
    public int updateTHiddenTrouble(THiddenTrouble tHiddenTrouble);

    /**
     * 删除隐患信息
     * 
     * @param troubleId 隐患信息ID
     * @return 结果
     */
    public int deleteTHiddenTroubleById(int troubleId);

    /**
     * 批量删除隐患信息
     * 
     * @param troubleIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTHiddenTroubleByIds(int[] troubleIds);
}
