package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 巡检记录对象 t_inspection_data
 * 
 * @author zehong
 * @date 2021-07-21
 */
public class TInspectionData extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 巡检记录id */
    private int dataId;

    /** 巡检计划id */
    @Excel(name = "巡检计划id")
    private int planId;

    /** 设备编号 */
    @Excel(name = "设备编号")
    private String deviceCode;

    /** 设备类型 */
    @Excel(name = "设备类型")
    private String deviceType;

    /** 处理状态（1不需处理，2已处理完成，3未处理完成） */
    @Excel(name = "处理状态", readConverterExp = "1=不需处理，2已处理完成，3未处理完成")
    private String dealStatus;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setDataId(int dataId)
    {
        this.dataId = dataId;
    }

    public int getDataId()
    {
        return dataId;
    }
    public void setPlanId(int planId)
    {
        this.planId = planId;
    }

    public int getPlanId()
    {
        return planId;
    }
    public void setDeviceCode(String deviceCode)
    {
        this.deviceCode = deviceCode;
    }

    public String getDeviceCode()
    {
        return deviceCode;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setDealStatus(String dealStatus)
    {
        this.dealStatus = dealStatus;
    }

    public String getDealStatus() 
    {
        return dealStatus;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("dataId", getDataId())
            .append("planId", getPlanId())
            .append("deviceCode", getDeviceCode())
            .append("deviceType", getDeviceType())
            .append("dealStatus", getDealStatus())
            .append("updateTime", getUpdateTime())
            .append("createTime", getCreateTime())
            .append("remarks", getRemarks())
            .toString();
    }
}
