import request from '@/utils/request'

// 查询企业基本信息列表
export function listInfo(query) {
  return request({
    url: '/enterprise/info/list',
    method: 'get',
    params: query
  })
}

// 查询企业基本信息详细
export function getInfo(infoId) {
  return request({
    url: '/enterprise/info/' + infoId,
    method: 'get'
  })
}

// 新增企业基本信息
export function addInfo(data) {
  return request({
    url: '/enterprise/info',
    method: 'post',
    data: data
  })
}

// 修改企业基本信息
export function updateInfo(data) {
  return request({
    url: '/enterprise/info',
    method: 'put',
    data: data
  })
}

// 删除企业基本信息
export function delInfo(infoId) {
  return request({
    url: '/enterprise/info/' + infoId,
    method: 'delete'
  })
}

// 导出企业基本信息
export function exportInfo(query) {
  return request({
    url: '/enterprise/info/export',
    method: 'get',
    params: query
  })
}
