package com.zehong.system.service.impl;

import java.util.List;

import com.zehong.system.domain.*;
import com.zehong.system.mapper.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.service.ITOrderFeedbackService;

/**
 * 工单反馈信息Service业务层处理
 * 
 * @author zehong
 * @date 2021-07-19
 */
@Service
public class TOrderFeedbackServiceImpl implements ITOrderFeedbackService 
{
    @Autowired
    private TOrderFeedbackMapper tOrderFeedbackMapper;
    @Autowired
    private TWorkOrderMapper tWorkOrderMapper;
    @Autowired
    private TInspectionDataMapper tInspectionDataMapper;
    @Autowired
    private THiddenTroubleMapper tHiddenTroubleMapper;
    @Autowired
    private TDeviceAlarmMapper tDeviceAlarmMapper;

    /**
     * 查询工单反馈信息
     * 
     * @param feedbackId 工单反馈信息ID
     * @return 工单反馈信息
     */
    @Override
    public TOrderFeedback selectTOrderFeedbackById(int feedbackId)
    {
        return tOrderFeedbackMapper.selectTOrderFeedbackById(feedbackId);
    }

    /**
     * 查询工单反馈信息列表
     * 
     * @param tOrderFeedback 工单反馈信息
     * @return 工单反馈信息
     */
    @Override
    public List<TOrderFeedback> selectTOrderFeedbackList(TOrderFeedback tOrderFeedback)
    {
        return tOrderFeedbackMapper.selectTOrderFeedbackList(tOrderFeedback);
    }

    /**
     * 新增工单反馈信息
     * 
     * @param tOrderFeedback 工单反馈信息
     * @return 结果
     */
    @Override
    public int insertTOrderFeedback(TOrderFeedback tOrderFeedback)
    {
        String deviceCode = tOrderFeedback.getDeviceCode();
        String dealStatus = tOrderFeedback.getDealStatus();

        // 根据工单类型和源id修改源数据状态
        TWorkOrder order = tWorkOrderMapper.selectTWorkOrderById(tOrderFeedback.getOrderId());
        String orderType = order.getOrderType();

        if("1".equals(orderType)){
            TInspectionData data = tInspectionDataMapper.selectTInspectionDataByCode(deviceCode);
            data.setDealStatus(dealStatus);
            tInspectionDataMapper.updateTInspectionData(data);

        } else if("2".equals(orderType)) {
            THiddenTrouble trouble = tHiddenTroubleMapper.selectTHiddenTroubleById(order.getResourceId());
            trouble.setDealStatus(dealStatus);
            tHiddenTroubleMapper.updateTHiddenTrouble(trouble);

        } else {
            TDeviceAlarm alarm = tDeviceAlarmMapper.selectTDeviceAlarmById(order.getResourceId());
            alarm.setDealStatus(dealStatus);
            tDeviceAlarmMapper.updateTDeviceAlarm(alarm);
        }

        // 如果工单状态是进行中，修改状态为已反馈
        if("2".equals(order.getOrderStatus())){
            order.setOrderStatus("3");
            tWorkOrderMapper.updateTWorkOrder(order);
        }

        return tOrderFeedbackMapper.insertTOrderFeedback(tOrderFeedback);
    }

    /**
     * 修改工单反馈信息
     * 
     * @param tOrderFeedback 工单反馈信息
     * @return 结果
     */
    @Override
    public int updateTOrderFeedback(TOrderFeedback tOrderFeedback)
    {
        return tOrderFeedbackMapper.updateTOrderFeedback(tOrderFeedback);
    }

    /**
     * 批量删除工单反馈信息
     * 
     * @param feedbackIds 需要删除的工单反馈信息ID
     * @return 结果
     */
    @Override
    public int deleteTOrderFeedbackByIds(int[] feedbackIds)
    {
        return tOrderFeedbackMapper.deleteTOrderFeedbackByIds(feedbackIds);
    }

    /**
     * 删除工单反馈信息信息
     * 
     * @param feedbackId 工单反馈信息ID
     * @return 结果
     */
    @Override
    public int deleteTOrderFeedbackById(int feedbackId)
    {
        return tOrderFeedbackMapper.deleteTOrderFeedbackById(feedbackId);
    }
}
