package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TPipe;

/**
 * 管道信息Mapper接口
 * 
 * @author zehong
 * @date 2021-07-08
 */
public interface TPipeMapper 
{
    /**
     * 查询管道信息
     * 
     * @param pipeId 管道信息ID
     * @return 管道信息
     */
    public TPipe selectTPipeById(int pipeId);

    /**
     * 查询管道信息
     *
     * @param pipeCode 管道编号
     * @return 管道信息
     */
    public TPipe selectTPipeByCode(String pipeCode);

    /**
     * 查询管道信息列表
     * 
     * @param tPipe 管道信息
     * @return 管道信息集合
     */
    public List<TPipe> selectTPipeList(TPipe tPipe);

    /**
     * 统计管道总长度
     * @return
     */
    public double countPipeLength();

    /**
     * 新增管道信息
     * 
     * @param tPipe 管道信息
     * @return 结果
     */
    public int insertTPipe(TPipe tPipe);

    /**
     * 修改管道信息
     * 
     * @param tPipe 管道信息
     * @return 结果
     */
    public int updateTPipe(TPipe tPipe);

    /**
     * 删除管道信息
     * 
     * @param pipeId 管道信息ID
     * @return 结果
     */
    public int deleteTPipeById(int pipeId);

    /**
     * 批量删除管道信息
     * 
     * @param pipeIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTPipeByIds(int[] pipeIds);
}
