package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 工单基础信息对象 t_work_order
 * 
 * @author zehong
 * @date 2021-07-19
 */
public class TWorkOrder extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 工单id */
    private String orderId;

    /** 工单类型（1巡检信息，2隐患信息，3报警信息） */
    @Excel(name = "工单类型", readConverterExp = "1巡检信息，2隐患信息，3报警信息")
    private String orderType;

    /** 源id */
    @Excel(name = "源id")
    private int resourceId;

    /** 工单名称 */
    @Excel(name = "工单名称")
    private String orderName;

    /** 工单状态（0未接收，1已接收，2进行中，3已反馈，4已归档） */
    @Excel(name = "工单状态", readConverterExp = "0未接收，1已接收，2进行中，3已反馈，4已归档")
    private String orderStatus;

    /** 指定执行人员（巡检员id） */
    @Excel(name = "指定执行人员", readConverterExp = "巡检员id")
    private Long appointInspector;

    /** 下发时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "下发时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date allotTime;

    /** 实际接收人员（巡检员id） */
    @Excel(name = "实际接收人员", readConverterExp = "巡检员id")
    private Long actualInspector;

    /** 实际接收时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "实际接收时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date actualTime;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setOrderId(String orderId) 
    {
        this.orderId = orderId;
    }

    public String getOrderId() 
    {
        return orderId;
    }
    public void setOrderType(String orderType) 
    {
        this.orderType = orderType;
    }

    public String getOrderType() 
    {
        return orderType;
    }

    public int getResourceId() {
        return resourceId;
    }

    public void setResourceId(int resourceId) {
        this.resourceId = resourceId;
    }

    public void setOrderName(String orderName)
    {
        this.orderName = orderName;
    }

    public String getOrderName() 
    {
        return orderName;
    }
    public void setOrderStatus(String orderStatus) 
    {
        this.orderStatus = orderStatus;
    }

    public String getOrderStatus() 
    {
        return orderStatus;
    }
    public void setAppointInspector(Long appointInspector)
    {
        this.appointInspector = appointInspector;
    }

    public Long getAppointInspector()
    {
        return appointInspector;
    }
    public void setAllotTime(Date allotTime) 
    {
        this.allotTime = allotTime;
    }

    public Date getAllotTime() 
    {
        return allotTime;
    }
    public void setActualInspector(Long actualInspector)
    {
        this.actualInspector = actualInspector;
    }

    public Long getActualInspector()
    {
        return actualInspector;
    }
    public void setActualTime(Date actualTime) 
    {
        this.actualTime = actualTime;
    }

    public Date getActualTime() 
    {
        return actualTime;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("orderId", getOrderId())
            .append("orderType", getOrderType())
            .append("orderName", getOrderName())
            .append("orderStatus", getOrderStatus())
            .append("createTime", getCreateTime())
            .append("appointInspector", getAppointInspector())
            .append("allotTime", getAllotTime())
            .append("actualInspector", getActualInspector())
            .append("actualTime", getActualTime())
            .append("remarks", getRemarks())
            .toString();
    }
}
