package com.zehong.system.service;

import java.util.List;
import java.util.Map;

import com.zehong.common.core.domain.TreeSelect;
import com.zehong.common.core.domain.entity.SysDept;
import com.zehong.system.domain.TDeviceInfo;

/**
 * 设备信息Service接口
 * 
 * @author zehong
 * @date 2021-07-09
 */
public interface ITDeviceInfoService 
{
    /**
     * 查询设备信息
     * 
     * @param deviceId 设备信息ID
     * @return 设备信息
     */
    public TDeviceInfo selectTDeviceInfoById(int deviceId);

    /**
     * 查询设备信息列表
     * 
     * @param tDeviceInfo 设备信息
     * @return 设备信息集合
     */
    public List<TDeviceInfo> selectTDeviceInfoList(TDeviceInfo tDeviceInfo);

    /**
     * 构建前端所需要下拉树结构
     *
     * @param deviceInfoList 设备列表
     * @return 下拉树结构列表
     */
    public List<Map<Object, Object>> buildDeviceTreeSelect(List<TDeviceInfo> deviceInfoList);

    /**
     * 统计各设备类型的设备总数
     * @return
     */
    public List<Map<Object, Object>> countDeviceByType();

    /**
     * 新增设备信息
     * 
     * @param tDeviceInfo 设备信息
     * @return 结果
     */
    public int insertTDeviceInfo(TDeviceInfo tDeviceInfo);

    /**
     * 修改设备信息
     * 
     * @param tDeviceInfo 设备信息
     * @return 结果
     */
    public int updateTDeviceInfo(TDeviceInfo tDeviceInfo);

    /**
     * 批量删除设备信息
     * 
     * @param deviceIds 需要删除的设备信息ID
     * @return 结果
     */
    public int deleteTDeviceInfoByIds(int[] deviceIds);

    /**
     * 删除设备信息信息
     * 
     * @param deviceId 设备信息ID
     * @return 结果
     */
    public int deleteTDeviceInfoById(int deviceId);
}
