package com.zehong.web.controller.deviceInspection;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TInspectionPlan;
import com.zehong.system.service.ITInspectionPlanService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 巡检计划Controller
 * 
 * @author zehong
 * @date 2021-07-21
 */
@RestController
@RequestMapping("/deviceInspection/inspectionPlan")
public class TInspectionPlanController extends BaseController
{
    @Autowired
    private ITInspectionPlanService tInspectionPlanService;

    /**
     * 查询巡检计划列表
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspectionPlan:list')")
    @GetMapping("/list")
    public TableDataInfo list(TInspectionPlan tInspectionPlan)
    {
        startPage();
        List<TInspectionPlan> list = tInspectionPlanService.selectTInspectionPlanList(tInspectionPlan);
        return getDataTable(list);
    }

    /**
     * 导出巡检计划列表
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspectionPlan:export')")
    @Log(title = "巡检计划", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TInspectionPlan tInspectionPlan)
    {
        List<TInspectionPlan> list = tInspectionPlanService.selectTInspectionPlanList(tInspectionPlan);
        ExcelUtil<TInspectionPlan> util = new ExcelUtil<TInspectionPlan>(TInspectionPlan.class);
        return util.exportExcel(list, "巡检计划数据");
    }

    /**
     * 获取巡检计划详细信息
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspectionPlan:query')")
    @GetMapping(value = "/{planId}")
    public AjaxResult getInfo(@PathVariable("planId") int planId)
    {
        return AjaxResult.success(tInspectionPlanService.selectTInspectionPlanById(planId));
    }

    /**
     * 新增巡检计划
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspectionPlan:add')")
    @Log(title = "巡检计划", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TInspectionPlan tInspectionPlan)
    {
        return toAjax(tInspectionPlanService.insertTInspectionPlan(tInspectionPlan));
    }

    /**
     * 修改巡检计划
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspectionPlan:edit')")
    @Log(title = "巡检计划", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TInspectionPlan tInspectionPlan)
    {
        return toAjax(tInspectionPlanService.updateTInspectionPlan(tInspectionPlan));
    }

    /**
     * 删除巡检计划
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspectionPlan:remove')")
    @Log(title = "巡检计划", businessType = BusinessType.DELETE)
	@DeleteMapping("/{planIds}")
    public AjaxResult remove(@PathVariable int[] planIds)
    {
        return toAjax(tInspectionPlanService.deleteTInspectionPlanByIds(planIds));
    }
}
