package com.zehong.system.domain;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 企业基本信息 t_enterprise_info
 * 
 * @author zehong
 * @date 2021-06-30
 */
public class TEnterpriseInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Integer infoId;

    /** 单位名称 */
    @Excel(name = "企业名称")
    private String unitName;

    /** 组织机构代码 */
    @Excel(name = "社会统一信用代码")
    private String orgCode;

    /** 营业执照图片路径 */
    @Excel(name = "营业执照图片路径")
    private String orgFilePath;

    /** 文件名称 */
    @Excel(name = "文件名称")
    private String orgFileName;

    /** 生产经营地址 */
    @Excel(name = "生产经营地址")
    private String runAddress;

    /** 注册地址 */
    @Excel(name = "注册地址")
    private String regAddress;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 法定代表人 */
    @Excel(name = "法定代表人")
    private String legalPerson;

    /** 法定代表人手机 */
    @Excel(name = "法定代表人电话")
    private String legalPersonPhone;

    /** 法人邮箱 */
    @Excel(name = "法人邮箱")
    private String legalPersonEmail;

    /** 创建人id */
    @Excel(name = "创建人id")
    private String createUserId;

    /** 更新人id */
    @Excel(name = "更新人id")
    private String updateUserId;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setInfoId(Integer infoId)
    {
        this.infoId = infoId;
    }

    public Integer getInfoId()
    {
        return infoId;
    }
    public void setUnitName(String unitName) 
    {
        this.unitName = unitName;
    }

    public String getUnitName() 
    {
        return unitName;
    }
    public void setOrgCode(String orgCode) 
    {
        this.orgCode = orgCode;
    }

    public String getOrgCode() 
    {
        return orgCode;
    }
    public void setOrgFilePath(String orgFilePath) 
    {
        this.orgFilePath = orgFilePath;
    }

    public String getOrgFilePath() 
    {
        return orgFilePath;
    }
    public void setOrgFileName(String orgFileName) 
    {
        this.orgFileName = orgFileName;
    }

    public String getOrgFileName() 
    {
        return orgFileName;
    }
    public void setRunAddress(String runAddress) 
    {
        this.runAddress = runAddress;
    }

    public String getRunAddress() 
    {
        return runAddress;
    }
    public void setRegAddress(String regAddress) 
    {
        this.regAddress = regAddress;
    }

    public String getRegAddress() 
    {
        return regAddress;
    }
    public void setLongitude(BigDecimal longitude)
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }
    public void setLegalPerson(String legalPerson) 
    {
        this.legalPerson = legalPerson;
    }

    public String getLegalPerson() 
    {
        return legalPerson;
    }
    public void setLegalPersonPhone(String legalPersonPhone) 
    {
        this.legalPersonPhone = legalPersonPhone;
    }

    public String getLegalPersonPhone() 
    {
        return legalPersonPhone;
    }
    public void setLegalPersonEmail(String legalPersonEmail) 
    {
        this.legalPersonEmail = legalPersonEmail;
    }

    public String getLegalPersonEmail() 
    {
        return legalPersonEmail;
    }
    public void setCreateUserId(String createUserId) 
    {
        this.createUserId = createUserId;
    }

    public String getCreateUserId() 
    {
        return createUserId;
    }
    public void setUpdateUserId(String updateUserId) 
    {
        this.updateUserId = updateUserId;
    }

    public String getUpdateUserId() 
    {
        return updateUserId;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("infoId", getInfoId())
            .append("unitName", getUnitName())
            .append("orgCode", getOrgCode())
            .append("orgFilePath", getOrgFilePath())
            .append("orgFileName", getOrgFileName())
            .append("runAddress", getRunAddress())
            .append("regAddress", getRegAddress())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("legalPerson", getLegalPerson())
            .append("legalPersonPhone", getLegalPersonPhone())
            .append("legalPersonEmail", getLegalPersonEmail())
            .append("createUserId", getCreateUserId())
            .append("updateUserId", getUpdateUserId())
            .append("updateTime", getUpdateTime())
            .append("createTime", getCreateTime())
            .append("remarks", getRemarks())
            .toString();
    }
}
