import request from '@/utils/request'

// 查询巡检计划列表
export function listInspectionPlan(query) {
  return request({
    url: '/deviceInspection/inspectionPlan/list',
    method: 'get',
    params: query
  })
}

// 查询巡检计划详细
export function getInspectionPlan(planId) {
  return request({
    url: '/deviceInspection/inspectionPlan/' + planId,
    method: 'get'
  })
}

// 新增巡检计划
export function addInspectionPlan(data) {
  return request({
    url: '/deviceInspection/inspectionPlan',
    method: 'post',
    data: data
  })
}

// 修改巡检计划
export function updateInspectionPlan(data) {
  return request({
    url: '/deviceInspection/inspectionPlan',
    method: 'put',
    data: data
  })
}

// 删除巡检计划
export function delInspectionPlan(planId) {
  return request({
    url: '/deviceInspection/inspectionPlan/' + planId,
    method: 'delete'
  })
}

// 导出巡检计划
export function exportInspectionPlan(query) {
  return request({
    url: '/deviceInspection/inspectionPlan/export',
    method: 'get',
    params: query
  })
}