package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TPipeMapper;
import com.zehong.system.domain.TPipe;
import com.zehong.system.service.ITPipeService;

/**
 * 管道信息Service业务层处理
 * 
 * @author zehong
 * @date 2021-07-08
 */
@Service
public class TPipeServiceImpl implements ITPipeService 
{
    @Autowired
    private TPipeMapper tPipeMapper;

    /**
     * 查询管道信息
     * 
     * @param pipeId 管道信息ID
     * @return 管道信息
     */
    @Override
    public TPipe selectTPipeById(int pipeId)
    {
        return tPipeMapper.selectTPipeById(pipeId);
    }

    /**
     * 查询管道信息列表
     * 
     * @param tPipe 管道信息
     * @return 管道信息
     */
    @Override
    public List<TPipe> selectTPipeList(TPipe tPipe)
    {
        return tPipeMapper.selectTPipeList(tPipe);
    }

    /**
     * 统计管道总长度
     * @return
     */
    @Override
    public double countPipeLength() {
        return tPipeMapper.countPipeLength();
    };

    /**
     * 新增管道信息
     * 
     * @param tPipe 管道信息
     * @return 结果
     */
    @Override
    public int insertTPipe(TPipe tPipe)
    {
        return tPipeMapper.insertTPipe(tPipe);
    }

    /**
     * 修改管道信息
     * 
     * @param tPipe 管道信息
     * @return 结果
     */
    @Override
    public int updateTPipe(TPipe tPipe)
    {
        return tPipeMapper.updateTPipe(tPipe);
    }

    /**
     * 批量删除管道信息
     * 
     * @param pipeIds 需要删除的管道信息ID
     * @return 结果
     */
    @Override
    public int deleteTPipeByIds(int[] pipeIds)
    {
        return tPipeMapper.deleteTPipeByIds(pipeIds);
    }

    /**
     * 删除管道信息信息
     * 
     * @param pipeId 管道信息ID
     * @return 结果
     */
    @Override
    public int deleteTPipeById(int pipeId)
    {
        return tPipeMapper.deleteTPipeById(pipeId);
    }
}
