package com.zehong.system.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import com.zehong.system.domain.TDeviceReportData;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 设备监控对象 t_device_report_data
 * 
 * @author zehong
 * @date 2021-08-09
 */
public class DeviceReportDataVo extends BaseEntity
{
    /** 设备上报id */
    private Long deviceReportDataId;

    /** 设备物联网编号 */
    @Excel(name = "设备物联网编号")
    private String deviceNum;

    /** 设备id */
    @Excel(name = "设备id")
    private Integer deviceId;

    /** 设备编号 */
    @Excel(name = "设备编号")
    private String deviceCode;

    /** 设备名称 */
    @Excel(name = "设备名称")
    private String deviceName;

    /** 设备类型 */
    @Excel(name = "设备类型")
    private String deviceType;

    /** 设备型号 */
    @Excel(name = "设备型号")
    private String deviceModel;

    /** 经度 */
    private BigDecimal longitude;

    /** 纬度 */
    private BigDecimal latitude;

    /** 设备监控数据列表（用于详情折线图） */
    private List<TDeviceReportData> deviceReportDataList;

    /** 标况累计量 */
    @Excel(name = "标况累计量")
    private BigDecimal standardConditionAccumulation;

    /** 工况累计量 */
    @Excel(name = "工况累计量")
    private BigDecimal workingConditionAccumulation;

    /** 剩余量 */
    @Excel(name = "剩余量")
    private BigDecimal residualQuantity;

    /** 标况流量 */
    @Excel(name = "标况流量")
    private BigDecimal standardConditionFlow;

    /** 工况流量 */
    @Excel(name = "工况流量")
    private BigDecimal workingConditionFlow;

    /** 温度 */
    @Excel(name = "温度")
    private BigDecimal temperature;

    /** 压力 */
    @Excel(name = "压力")
    private BigDecimal pressure;

    /** 上报时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "上报时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date reportTime;

    /** 通讯状态 */
    @Excel(name = "通讯状态")
    private String communicationStatus;

    /** 设备状态 */
    @Excel(name = "设备状态")
    private String deviceStatus;

    public void setDeviceReportDataId(Long deviceReportDataId) 
    {
        this.deviceReportDataId = deviceReportDataId;
    }

    public Long getDeviceReportDataId() 
    {
        return deviceReportDataId;
    }

    public void setDeviceNum(String deviceNum)
    {
        this.deviceNum = deviceNum;
    }

    public String getDeviceNum()
    {
        return deviceNum;
    }

    public Integer getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(Integer deviceId) {
        this.deviceId = deviceId;
    }

    public String getDeviceCode() {
        return deviceCode;
    }

    public void setDeviceCode(String deviceCode) {
        this.deviceCode = deviceCode;
    }

    public String getDeviceName() {
        return deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getDeviceModel() {
        return deviceModel;
    }

    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public BigDecimal getLongitude() {
        return longitude;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public BigDecimal getLatitude() {
        return latitude;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public List<TDeviceReportData> getDeviceReportDataList() {
        return deviceReportDataList;
    }

    public void setDeviceReportDataList(List<TDeviceReportData> deviceReportDataList) {
        this.deviceReportDataList = deviceReportDataList;
    }

    public void setStandardConditionAccumulation(BigDecimal standardConditionAccumulation)
    {
        this.standardConditionAccumulation = standardConditionAccumulation;
    }

    public BigDecimal getStandardConditionAccumulation() 
    {
        return standardConditionAccumulation;
    }
    public void setWorkingConditionAccumulation(BigDecimal workingConditionAccumulation) 
    {
        this.workingConditionAccumulation = workingConditionAccumulation;
    }

    public BigDecimal getWorkingConditionAccumulation() 
    {
        return workingConditionAccumulation;
    }
    public void setResidualQuantity(BigDecimal residualQuantity) 
    {
        this.residualQuantity = residualQuantity;
    }

    public BigDecimal getResidualQuantity() 
    {
        return residualQuantity;
    }
    public void setStandardConditionFlow(BigDecimal standardConditionFlow) 
    {
        this.standardConditionFlow = standardConditionFlow;
    }

    public BigDecimal getStandardConditionFlow() 
    {
        return standardConditionFlow;
    }
    public void setWorkingConditionFlow(BigDecimal workingConditionFlow) 
    {
        this.workingConditionFlow = workingConditionFlow;
    }

    public BigDecimal getWorkingConditionFlow() 
    {
        return workingConditionFlow;
    }
    public void setTemperature(BigDecimal temperature) 
    {
        this.temperature = temperature;
    }

    public BigDecimal getTemperature() 
    {
        return temperature;
    }
    public void setPressure(BigDecimal pressure) 
    {
        this.pressure = pressure;
    }

    public BigDecimal getPressure() 
    {
        return pressure;
    }
    public void setReportTime(Date reportTime) 
    {
        this.reportTime = reportTime;
    }

    public Date getReportTime() 
    {
        return reportTime;
    }
    public void setCommunicationStatus(String communicationStatus) 
    {
        this.communicationStatus = communicationStatus;
    }

    public String getCommunicationStatus() 
    {
        return communicationStatus;
    }
    public void setDeviceStatus(String deviceStatus) 
    {
        this.deviceStatus = deviceStatus;
    }

    public String getDeviceStatus() 
    {
        return deviceStatus;
    }

}
