package com.zehong.web.controller.enterprise;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TEnterpriseInfo;
import com.zehong.system.service.ITEnterpriseInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 企业基本信息
 * 
 * @author zehong
 * @date 2021-06-30
 */
@RestController
@RequestMapping("/enterprise/info")
public class TEnterpriseInfoController extends BaseController
{
    @Autowired
    private ITEnterpriseInfoService tEnterpriseInfoService;

    /**
     * 查询企业基本信息列表
     */
    @PreAuthorize("@ss.hasPermi('enterprise:info:list')")
    @GetMapping("/list")
    public TableDataInfo list(TEnterpriseInfo tEnterpriseInfo)
    {
        startPage();
        List<TEnterpriseInfo> list = tEnterpriseInfoService.selectTEnterpriseInfoList(tEnterpriseInfo);
        return getDataTable(list);
    }

    /**
     * 导出企业基本信息列表
     */
    @PreAuthorize("@ss.hasPermi('enterprise:info:export')")
    @Log(title = "企业基本信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TEnterpriseInfo tEnterpriseInfo)
    {
        List<TEnterpriseInfo> list = tEnterpriseInfoService.selectTEnterpriseInfoList(tEnterpriseInfo);
        ExcelUtil<TEnterpriseInfo> util = new ExcelUtil<TEnterpriseInfo>(TEnterpriseInfo.class);
        return util.exportExcel(list, "企业基本信息数据");
    }

    /**
     * 获取企业基本信息详情
     */
    @PreAuthorize("@ss.hasPermi('enterprise:info:query')")
    @GetMapping(value = "/{infoId}")
    public AjaxResult getInfo(@PathVariable("infoId") int infoId)
    {
        return AjaxResult.success(tEnterpriseInfoService.selectTEnterpriseInfoById(infoId));
    }

    /**
     * 新增企业基本信息
     */
    @PreAuthorize("@ss.hasPermi('enterprise:info:add')")
    @Log(title = "企业基本信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TEnterpriseInfo tEnterpriseInfo)
    {
        return toAjax(tEnterpriseInfoService.insertTEnterpriseInfo(tEnterpriseInfo));
    }

    /**
     * 修改企业基本信息
     */
    @PreAuthorize("@ss.hasPermi('enterprise:info:edit')")
    @Log(title = "企业基本信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TEnterpriseInfo tEnterpriseInfo)
    {
        return toAjax(tEnterpriseInfoService.updateTEnterpriseInfo(tEnterpriseInfo));
    }

    /**
     * 删除企业基本信息
     */
    @PreAuthorize("@ss.hasPermi('enterprise:info:remove')")
    @Log(title = "企业基本信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{infoIds}")
    public AjaxResult remove(@PathVariable int[] infoIds)
    {
        return toAjax(tEnterpriseInfoService.deleteTEnterpriseInfoByIds(infoIds));
    }
}
