package com.zehong.web.controller.riskManagement;

import java.util.List;

import com.github.pagehelper.PageInfo;
import com.zehong.system.domain.form.HiddenTroubleForm;
import com.zehong.system.domain.vo.HiddenTroubleVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.THiddenTrouble;
import com.zehong.system.service.ITHiddenTroubleService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 隐患信息Controller
 * 
 * @author zehong
 * @date 2021-07-21
 */
@RestController
@RequestMapping("/riskManagement/hiddenTrouble")
public class THiddenTroubleController extends BaseController
{
    @Autowired
    private ITHiddenTroubleService tHiddenTroubleService;

    /**
     * 查询隐患信息列表
     */
    @PreAuthorize("@ss.hasPermi('riskManagement:hiddenTrouble:list')")
    @GetMapping("/list")
    public TableDataInfo list(HiddenTroubleForm hiddenTroubleForm)
    {
        startPage();
        PageInfo<HiddenTroubleVo> page = tHiddenTroubleService.selectTHiddenTroublePage(hiddenTroubleForm);
        return getDataTable(page);
    }

    /**
     * 地图初始化隐患
     * @param
     * @return
     */
    @GetMapping("/getMapHiddenTroublelist")
    public AjaxResult getMapHiddenTroublelist(String troubleName)
    {
        List<HiddenTroubleVo> list = tHiddenTroubleService.getMapTHiddenTroubleList(troubleName);
        return AjaxResult.success(list);
    }

    /**
     * 导出隐患信息列表
     */
    @PreAuthorize("@ss.hasPermi('riskManagement:hiddenTrouble:export')")
    @Log(title = "隐患信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(HiddenTroubleForm hiddenTroubleForm)
    {
        hiddenTroubleForm.setDealStatus("3");
        List<HiddenTroubleVo> list = tHiddenTroubleService.selectTHiddenTroubleList(hiddenTroubleForm);
        ExcelUtil<HiddenTroubleVo> util = new ExcelUtil<HiddenTroubleVo>(HiddenTroubleVo.class);
        return util.exportExcel(list, "隐患信息数据");
    }

    /**
     * 获取隐患信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('riskManagement:hiddenTrouble:query')")
    @GetMapping(value = "/{troubleId}")
    public AjaxResult getInfo(@PathVariable("troubleId") int troubleId) throws Exception
    {
        HiddenTroubleVo hiddenTroubleVo = null;
        try {
            hiddenTroubleVo = tHiddenTroubleService.selectTHiddenTroubleById(troubleId);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Exception("获取隐患信息详情失败");
        }
        return AjaxResult.success(hiddenTroubleVo);
    }

    /**
     * 新增隐患信息
     */
    @PreAuthorize("@ss.hasPermi('riskManagement:hiddenTrouble:add')")
    @Log(title = "隐患信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody THiddenTrouble tHiddenTrouble)
    {
        return toAjax(tHiddenTroubleService.insertTHiddenTrouble(tHiddenTrouble));
    }

    /**
     * 修改隐患信息
     */
    @PreAuthorize("@ss.hasPermi('riskManagement:hiddenTrouble:edit')")
    @Log(title = "隐患信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody THiddenTrouble tHiddenTrouble)
    {
        return toAjax(tHiddenTroubleService.updateTHiddenTrouble(tHiddenTrouble));
    }

    /**
     * 删除隐患信息
     */
    @PreAuthorize("@ss.hasPermi('riskManagement:hiddenTrouble:remove')")
    @Log(title = "隐患信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{troubleIds}")
    public AjaxResult remove(@PathVariable int[] troubleIds)
    {
        return toAjax(tHiddenTroubleService.deleteTHiddenTroubleByIds(troubleIds));
    }
}
