package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TInspector;

/**
 * 巡检员Service接口
 * 
 * @author zehong
 * @date 2021-07-08
 */
public interface ITInspectorService 
{
    /**
     * 查询巡检员
     * 
     * @param inspectorId 巡检员ID
     * @return 巡检员
     */
    public TInspector selectTInspectorById(Long inspectorId);

    /**
     * 查询巡检员列表
     * 
     * @param tInspector 巡检员
     * @return 巡检员集合
     */
    public List<TInspector> selectTInspectorList(TInspector tInspector);

    /**
     * 新增巡检员
     * 
     * @param tInspector 巡检员
     * @return 结果
     */
    public int insertTInspector(TInspector tInspector);

    /**
     * 修改巡检员
     * 
     * @param tInspector 巡检员
     * @return 结果
     */
    public int updateTInspector(TInspector tInspector);

    /**
     * 批量删除巡检员
     * 
     * @param inspectorIds 需要删除的巡检员ID
     * @return 结果
     */
    public int deleteTInspectorByIds(Long[] inspectorIds);

    /**
     * 删除巡检员信息
     * 
     * @param inspectorId 巡检员ID
     * @return 结果
     */
    public int deleteTInspectorById(Long inspectorId);
}
