package com.zehong.system.service.impl;

import java.util.ArrayList;
import java.util.List;

import com.zehong.common.core.domain.entity.SysDictData;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.StringUtils;
import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.domain.TDeviceReportData;
import com.zehong.system.domain.TPipe;
import com.zehong.system.domain.form.DeviceAlarmForm;
import com.zehong.system.domain.vo.DeviceAlarmVo;
import com.zehong.system.mapper.TDeviceInfoMapper;
import com.zehong.system.mapper.TDeviceReportDataMapper;
import com.zehong.system.mapper.TPipeMapper;
import com.zehong.system.service.ISysDictTypeService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TDeviceAlarmMapper;
import com.zehong.system.domain.TDeviceAlarm;
import com.zehong.system.service.ITDeviceAlarmService;

/**
 * 报警信息Service业务层处理
 * 
 * @author zehong
 * @date 2021-07-21
 */
@Service
public class TDeviceAlarmServiceImpl implements ITDeviceAlarmService 
{
    @Autowired
    private TDeviceAlarmMapper tDeviceAlarmMapper;
    @Autowired
    private TDeviceInfoMapper tDeviceInfoMapper;
    @Autowired
    private TPipeMapper tPipeMapper;
    @Autowired
    private TDeviceReportDataMapper tDeviceReportDataMapper;

    @Autowired
    private ISysDictTypeService iSysDictTypeService;

    /**
     * 查询报警信息
     * 
     * @param alarmId 报警信息ID
     * @return 报警信息
     */
    @Override
    public DeviceAlarmVo selectTDeviceAlarmById(int alarmId) throws Exception
    {
        DeviceAlarmVo deviceAlarmVo = new DeviceAlarmVo();
        TDeviceAlarm tDeviceAlarm = tDeviceAlarmMapper.selectTDeviceAlarmById(alarmId);
        BeanUtils.copyProperties(tDeviceAlarm, deviceAlarmVo);

        if (StringUtils.isNotEmpty(tDeviceAlarm.getAlarmType())) {
            List<SysDictData> sysDictDataList = iSysDictTypeService.selectDictDataByType("t_alarm_type");
            for (SysDictData sysDictData : sysDictDataList) {
                if (tDeviceAlarm.getAlarmType().equals(sysDictData.getDictValue())) {
                    deviceAlarmVo.setAlarmType(sysDictData.getDictLabel());
                }
            }
        }

        if (StringUtils.isNotEmpty(tDeviceAlarm.getDeviceType())) {
            List<SysDictData> sysDictDataList = iSysDictTypeService.selectDictDataByType("t_trouble_device_type");
            for (SysDictData sysDictData : sysDictDataList) {
                if (tDeviceAlarm.getDeviceType().equals(sysDictData.getDictValue())) {
                    deviceAlarmVo.setDeviceType(sysDictData.getDictLabel());
                }
            }
        }

        if("0".equals(tDeviceAlarm.getDeviceType())){
            TPipe pipe = tPipeMapper.selectTPipeById(tDeviceAlarm.getDeviceId());
            deviceAlarmVo.setDeviceCode(pipe.getPipeCode());
            deviceAlarmVo.setDeviceName(pipe.getPipeName());
            deviceAlarmVo.setCoordinates(pipe.getCoordinates());
        } else {
            TDeviceInfo deviceInfo = tDeviceInfoMapper.selectTDeviceInfoById(tDeviceAlarm.getDeviceId());
            deviceAlarmVo.setDeviceCode(deviceInfo.getDeviceCode());
            deviceAlarmVo.setDeviceName(deviceInfo.getDeviceName());
            deviceAlarmVo.setIotNo(deviceInfo.getIotNo());
            deviceAlarmVo.setLongitude(deviceInfo.getLongitude());
            deviceAlarmVo.setLatitude(deviceInfo.getLatitude());

            // 查询当前设备开始报警时间前后一小时的数据
            TDeviceReportData tDeviceReportData = new TDeviceReportData();
            tDeviceReportData.setDeviceNum(deviceInfo.getIotNo());
            tDeviceReportData.setReportTime(tDeviceAlarm.getStartTime());

            List<TDeviceReportData> deviceReportDataList = tDeviceReportDataMapper.getAlarmDeviceReportDataList(tDeviceReportData);
            if(deviceReportDataList.size() != 0) {
                deviceAlarmVo.setDeviceReportDataList(deviceReportDataList);
            }
        }

        return deviceAlarmVo;
    }

    /**
     * 查询报警信息列表
     * 
     * @param deviceAlarmForm 报警信息
     * @return 报警信息
     */
    @Override
    public List<DeviceAlarmVo> selectTDeviceAlarmList(DeviceAlarmForm deviceAlarmForm) throws Exception
    {
        List<DeviceAlarmVo> list = new ArrayList<>();
        List<TDeviceAlarm> deviceAlarmList = new ArrayList<>();

        if(deviceAlarmForm.getDeviceCode() != null){
            List<TDeviceAlarm> pipeList = tDeviceAlarmMapper.selectTDeviceAlarmByPipeCode(deviceAlarmForm);
            List<TDeviceAlarm> deviceList = tDeviceAlarmMapper.selectTDeviceAlarmByDeviceCode(deviceAlarmForm);
            if(pipeList.size() != 0){
                deviceAlarmList.addAll(pipeList);
            }
            if(deviceList.size() != 0){
                deviceAlarmList.addAll(deviceList);
            }
        } else {
            deviceAlarmList = tDeviceAlarmMapper.selectTDeviceAlarmList(deviceAlarmForm);
        }

        if(deviceAlarmList.size() != 0) {
            for (TDeviceAlarm alarm : deviceAlarmList) {
                DeviceAlarmVo deviceAlarmVo = new DeviceAlarmVo();
                BeanUtils.copyProperties(alarm, deviceAlarmVo);

                if ("0".equals(alarm.getDeviceType())) {
                    TPipe pipe = tPipeMapper.selectTPipeById(alarm.getDeviceId());
                    if (pipe != null) {
                        deviceAlarmVo.setDeviceCode(pipe.getPipeCode());
                        deviceAlarmVo.setDeviceName(pipe.getPipeName());
                    }
                } else {
                    TDeviceInfo deviceInfo = tDeviceInfoMapper.selectTDeviceInfoById(alarm.getDeviceId());
                    if (deviceInfo != null) {
                        deviceAlarmVo.setDeviceCode(deviceInfo.getDeviceCode());
                        deviceAlarmVo.setDeviceName(deviceInfo.getDeviceName());
                    }
                }

                if (StringUtils.isNotEmpty(alarm.getAlarmType())) {
                    List<SysDictData> sysDictDataList = iSysDictTypeService.selectDictDataByType("t_alarm_type");
                    for (SysDictData sysDictData : sysDictDataList) {
                        if (alarm.getAlarmType().equals(sysDictData.getDictValue())) {
                            deviceAlarmVo.setAlarmType(sysDictData.getDictLabel());
                        }
                    }
                }

                if (StringUtils.isNotEmpty(alarm.getDeviceType())) {
                    List<SysDictData> sysDictDataList = iSysDictTypeService.selectDictDataByType("t_trouble_device_type");
                    for (SysDictData sysDictData : sysDictDataList) {
                        if (alarm.getDeviceType().equals(sysDictData.getDictValue())) {
                            deviceAlarmVo.setDeviceType(sysDictData.getDictLabel());
                        }
                    }
                }

                list.add(deviceAlarmVo);
            }
        }

        return list;
    }

    /**
     * 新增报警信息
     * 
     * @param tDeviceAlarm 报警信息
     * @return 结果
     */
    @Override
    public int insertTDeviceAlarm(TDeviceAlarm tDeviceAlarm)
    {
        tDeviceAlarm.setCreateTime(DateUtils.getNowDate());
        return tDeviceAlarmMapper.insertTDeviceAlarm(tDeviceAlarm);
    }

    /**
     * 修改报警信息
     * 
     * @param tDeviceAlarm 报警信息
     * @return 结果
     */
    @Override
    public int updateTDeviceAlarm(TDeviceAlarm tDeviceAlarm)
    {
        tDeviceAlarm.setUpdateTime(DateUtils.getNowDate());
        return tDeviceAlarmMapper.updateTDeviceAlarm(tDeviceAlarm);
    }

    /**
     * 批量删除报警信息
     * 
     * @param alarmIds 需要删除的报警信息ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceAlarmByIds(int[] alarmIds)
    {
        return tDeviceAlarmMapper.deleteTDeviceAlarmByIds(alarmIds);
    }

    /**
     * 删除报警信息信息
     * 
     * @param alarmId 报警信息ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceAlarmById(int alarmId)
    {
        return tDeviceAlarmMapper.deleteTDeviceAlarmById(alarmId);
    }

    /**
     * 查询报警设备
     * @return TDeviceAlarm
     */
    @Override
    public List<TDeviceAlarm> selectAlarmDevice (){
        return tDeviceAlarmMapper.selectAlarmDevice();
    }
}
