package com.zehong.system.service;

import java.util.List;

import com.github.pagehelper.PageInfo;
import com.zehong.system.domain.TPipe;
import com.zehong.system.domain.vo.PipeVo;

/**
 * 管道信息Service接口
 * 
 * @author zehong
 * @date 2021-07-08
 */
public interface ITPipeService 
{
    /**
     * 查询管道信息
     * 
     * @param pipeId 管道信息ID
     * @return 管道信息
     */
    public PipeVo selectTPipeById(int pipeId);

    /**
     * 查询管道信息列表
     * 
     * @param tPipe 管道信息
     * @return 管道信息集合
     */
    public List<PipeVo> selectTPipeList(TPipe tPipe);

    /**
     * 查询管道信息列表
     *
     * @param tPipe 管道信息
     * @return 管道信息集合
     */
    public PageInfo<PipeVo> selectTPipePage(TPipe tPipe);

    /**
     * 统计管道总长度
     * @param
     * @return
     */
    public double countPipeLength();

    /**
     * 新增管道信息
     * 
     * @param tPipe 管道信息
     * @return 结果
     */
    public int insertTPipe(TPipe tPipe);

    /**
     * 修改管道信息
     * 
     * @param tPipe 管道信息
     * @return 结果
     */
    public int updateTPipe(TPipe tPipe);

    /**
     * 批量删除管道信息
     * 
     * @param pipeIds 需要删除的管道信息ID
     * @return 结果
     */
    public int deleteTPipeByIds(int[] pipeIds);

    /**
     * 删除管道信息信息
     * 
     * @param pipeId 管道信息ID
     * @return 结果
     */
    public int deleteTPipeById(int pipeId);
}
