package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TOrderFeedback;

/**
 * 工单反馈信息Service接口
 * 
 * @author zehong
 * @date 2021-07-19
 */
public interface ITOrderFeedbackService 
{
    /**
     * 查询工单反馈信息
     * 
     * @param feedbackId 工单反馈信息ID
     * @return 工单反馈信息
     */
    public TOrderFeedback selectTOrderFeedbackById(int feedbackId);

    /**
     * 查询工单反馈信息列表
     * 
     * @param tOrderFeedback 工单反馈信息
     * @return 工单反馈信息集合
     */
    public List<TOrderFeedback> selectTOrderFeedbackList(TOrderFeedback tOrderFeedback);

    /**
     * 新增工单反馈信息
     * 
     * @param tOrderFeedback 工单反馈信息
     * @return 结果
     */
    public int insertTOrderFeedback(TOrderFeedback tOrderFeedback) throws Exception;

    /**
     * 修改工单反馈信息
     * 
     * @param tOrderFeedback 工单反馈信息
     * @return 结果
     */
    public int updateTOrderFeedback(TOrderFeedback tOrderFeedback);

    /**
     * 批量删除工单反馈信息
     * 
     * @param feedbackIds 需要删除的工单反馈信息ID
     * @return 结果
     */
    public int deleteTOrderFeedbackByIds(int[] feedbackIds);

    /**
     * 删除工单反馈信息信息
     * 
     * @param feedbackId 工单反馈信息ID
     * @return 结果
     */
    public int deleteTOrderFeedbackById(int feedbackId);
    /**
     * 查询工单的反馈信息列表
     * @param orderId
     * @return
     */
    public List<TOrderFeedback> selectTOrderFeedbackByOrderId(String orderId);
}
