package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TMonitorDevice;

/**
 * 设备监控Service接口
 * 
 * @author zehong
 * @date 2021-08-05
 */
public interface ITMonitorDeviceService 
{
    /**
     * 查询设备监控
     * 
     * @param monitorId 设备监控ID
     * @return 设备监控
     */
    public TMonitorDevice selectTMonitorDeviceById(Long monitorId);

    /**
     * 查询设备监控列表
     * 
     * @param tMonitorDevice 设备监控
     * @return 设备监控集合
     */
    public List<TMonitorDevice> selectTMonitorDeviceList(TMonitorDevice tMonitorDevice);

    /**
     * 新增设备监控
     * 
     * @param tMonitorDevice 设备监控
     * @return 结果
     */
    public int insertTMonitorDevice(TMonitorDevice tMonitorDevice);

    /**
     * 修改设备监控
     * 
     * @param tMonitorDevice 设备监控
     * @return 结果
     */
    public int updateTMonitorDevice(TMonitorDevice tMonitorDevice);

    /**
     * 批量删除设备监控
     * 
     * @param monitorIds 需要删除的设备监控ID
     * @return 结果
     */
    public int deleteTMonitorDeviceByIds(Long[] monitorIds);

    /**
     * 删除设备监控信息
     * 
     * @param monitorId 设备监控ID
     * @return 结果
     */
    public int deleteTMonitorDeviceById(Long monitorId);
}
