package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TDeviceAlarm;
import com.zehong.system.domain.form.DeviceAlarmForm;

/**
 * 报警信息Mapper接口
 * 
 * @author zehong
 * @date 2021-07-21
 */
public interface TDeviceAlarmMapper 
{
    /**
     * 查询报警信息
     * 
     * @param alarmId 报警信息ID
     * @return 报警信息
     */
    public TDeviceAlarm selectTDeviceAlarmById(int alarmId);

    /**
     * 查询报警信息列表
     * 
     * @param deviceAlarmForm 报警信息
     * @return 报警信息集合
     */
    public List<TDeviceAlarm> selectTDeviceAlarmList(DeviceAlarmForm deviceAlarmForm);

    /**
     * 查询报警信息列表
     *
     * @param deviceAlarmForm 报警信息
     * @return 报警信息集合
     */
    public List<TDeviceAlarm> selectTDeviceAlarmByPipeCode(DeviceAlarmForm deviceAlarmForm);

    /**
     * 查询报警信息列表
     *
     * @param deviceAlarmForm 报警信息
     * @return 报警信息集合
     */
    public List<TDeviceAlarm> selectTDeviceAlarmByDeviceCode(DeviceAlarmForm deviceAlarmForm);

    /**
     * 新增报警信息
     * 
     * @param tDeviceAlarm 报警信息
     * @return 结果
     */
    public int insertTDeviceAlarm(TDeviceAlarm tDeviceAlarm);

    /**
     * 修改报警信息
     * 
     * @param tDeviceAlarm 报警信息
     * @return 结果
     */
    public int updateTDeviceAlarm(TDeviceAlarm tDeviceAlarm);

    /**
     * 删除报警信息
     * 
     * @param alarmId 报警信息ID
     * @return 结果
     */
    public int deleteTDeviceAlarmById(int alarmId);

    /**
     * 批量删除报警信息
     * 
     * @param alarmIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTDeviceAlarmByIds(int[] alarmIds);

    /**
     * 查询报警设备
     * @return TDeviceAlarm
     */
    List<TDeviceAlarm> selectAlarmDevice ();
}
