package com.zehong.web.controller.inspectorLocation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.utils.StringUtils;
import com.zehong.system.domain.vo.TUserLocationVo;
import com.zehong.system.service.ISysUserService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TUserLocation;
import com.zehong.system.service.ITUserLocationService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 巡检员定位Controller
 * 
 * @author zehong
 * @date 2021-07-31
 */
@RestController
@RequestMapping("/system/location")
public class TUserLocationController extends BaseController
{
    @Autowired
    private ITUserLocationService tUserLocationService;

    @Autowired
    private ISysUserService userService;

    /**
     * 查询巡检员定位列表
     */
    @PreAuthorize("@ss.hasPermi('system:location:list')")
    @GetMapping("/list")
    public TableDataInfo list(TUserLocation tUserLocation)
    {
        startPage();
        List<TUserLocation> list = tUserLocationService.selectTUserLocationList(tUserLocation);
        return getDataTable(list);
    }

    /**
     * 初始化巡检员位置及巡检员路线
     * @param tUserLocationVo
     * @return
     */
    @GetMapping("/getInspectorLocations")
    public AjaxResult getInspectorLocations(TUserLocationVo tUserLocationVo){
        //巡检人员初始化
        if(null == tUserLocationVo.getUserId() && StringUtils.isEmpty(tUserLocationVo.getUserName())){
            List<SysUser> inspectors = userService.selectInspectorList();
            List<TUserLocation> inspectorLocations = new ArrayList<>();
            Map<String,Object> map = new HashMap<>(16);
            for(SysUser sysUser : inspectors){
                map.put("userId",sysUser.getUserId());
                map.put("initInspectors","initInspectors");
                inspectorLocations.addAll(tUserLocationService.selectTUserLocationListByMap(map));
            }
            return AjaxResult.success(inspectorLocations);
        }
        //查询巡检人员路线
        if(StringUtils.isEmpty(tUserLocationVo.getUserName())){
            Map<String,Object> map = new HashMap<>(16);
            map.put("userId",tUserLocationVo.getUserId());
            map.put("beginTime",tUserLocationVo.getBeginTime());
            map.put("endTime",tUserLocationVo.getEndTime());
            return AjaxResult.success(tUserLocationService.selectTUserLocationListByMap(map));
        }
        //搜索
        Map<String,Object> map = new HashMap<>(16);
        map.put("userName",tUserLocationVo.getUserName());
        map.put("initInspectors","initInspectors");
        return AjaxResult.success(tUserLocationService.selectTUserLocationListByMap(map));
    }

    /**
     * 导出巡检员定位列表
     */
    @PreAuthorize("@ss.hasPermi('system:location:export')")
    @Log(title = "巡检员定位", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TUserLocation tUserLocation)
    {
        List<TUserLocation> list = tUserLocationService.selectTUserLocationList(tUserLocation);
        ExcelUtil<TUserLocation> util = new ExcelUtil<TUserLocation>(TUserLocation.class);
        return util.exportExcel(list, "巡检员定位数据");
    }

    /**
     * 获取巡检员定位详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:location:query')")
    @GetMapping(value = "/{locationId}")
    public AjaxResult getInfo(@PathVariable("locationId") Long locationId)
    {
        return AjaxResult.success(tUserLocationService.selectTUserLocationById(locationId));
    }

    /**
     * 新增巡检员定位
     */
    //@PreAuthorize("@ss.hasPermi('system:location:add')")
    @Log(title = "巡检员定位", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TUserLocation tUserLocation)
    {
        return toAjax(tUserLocationService.insertTUserLocation(tUserLocation));
    }

    /**
     * 修改巡检员定位
     */
    @PreAuthorize("@ss.hasPermi('system:location:edit')")
    @Log(title = "巡检员定位", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TUserLocation tUserLocation)
    {
        return toAjax(tUserLocationService.updateTUserLocation(tUserLocation));
    }

    /**
     * 删除巡检员定位
     */
    @PreAuthorize("@ss.hasPermi('system:location:remove')")
    @Log(title = "巡检员定位", businessType = BusinessType.DELETE)
	@DeleteMapping("/{locationIds}")
    public AjaxResult remove(@PathVariable Long[] locationIds)
    {
        return toAjax(tUserLocationService.deleteTUserLocationByIds(locationIds));
    }
}
