package com.zehong.web.controller.dataMonitoring;

import java.util.List;

import com.github.pagehelper.PageInfo;
import com.zehong.system.domain.form.DeviceReportDataForm;
import com.zehong.system.domain.vo.DeviceReportDataVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TDeviceReportData;
import com.zehong.system.service.ITDeviceReportDataService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 设备监控Controller
 * 
 * @author zehong
 * @date 2021-08-09
 */
@RestController
@RequestMapping("/dataMonitoring/reportData")
public class TDeviceReportDataController extends BaseController
{
    @Autowired
    private ITDeviceReportDataService tDeviceReportDataService;

    /**
     * 查询设备历史监控列表
     */
    @PreAuthorize("@ss.hasPermi('dataMonitoring:reportData:list')")
    @GetMapping("/list")
    public TableDataInfo list(DeviceReportDataForm deviceReportDataForm)
    {
        startPage();
        PageInfo<DeviceReportDataVo> page = tDeviceReportDataService.selectTDeviceReportDataPage(deviceReportDataForm);
        return getDataTable(page);
    }

    /**
     * 查询设备实时监控列表
     */
    @PreAuthorize("@ss.hasPermi('dataMonitoring:reportData:realtimeList')")
    @GetMapping("/realtimeList")
    public TableDataInfo realtimeList(DeviceReportDataForm deviceReportDataForm)
    {
        startPage();
        PageInfo<DeviceReportDataVo> page = tDeviceReportDataService.selectRealtimeDataPage(deviceReportDataForm);
        return getDataTable(page);
    }

    /**
     * 导出设备监控列表
     */
    @PreAuthorize("@ss.hasPermi('dataMonitoring:reportData:export')")
    @Log(title = "设备监控", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(DeviceReportDataForm deviceReportDataForm)
    {
        List<DeviceReportDataVo> list = tDeviceReportDataService.selectTDeviceReportDataList(deviceReportDataForm);
        ExcelUtil<DeviceReportDataVo> util = new ExcelUtil<DeviceReportDataVo>(DeviceReportDataVo.class);
        return util.exportExcel(list, "设备监控数据");
    }

    /**
     * 获取设备监控数据详细信息
     */
    @PreAuthorize("@ss.hasPermi('dataMonitoring:reportData:query')")
    @GetMapping(value = "/{deviceId}")
    public AjaxResult getInfo(@PathVariable("deviceId") int deviceId) throws Exception
    {
        DeviceReportDataVo deviceReportDataVo = null;
        try {
            deviceReportDataVo = tDeviceReportDataService.selectTDeviceReportDataByDeviceId(deviceId);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Exception("获取设备监控数据详细信息失败");
        }
        return AjaxResult.success(deviceReportDataVo);
    }

    /**
     * 新增设备监控
     */
    @PreAuthorize("@ss.hasPermi('dataMonitoring:reportData:add')")
    @Log(title = "设备监控", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TDeviceReportData tDeviceReportData)
    {
        return toAjax(tDeviceReportDataService.insertTDeviceReportData(tDeviceReportData));
    }

    /**
     * 修改设备监控
     */
    @PreAuthorize("@ss.hasPermi('dataMonitoring:reportData:edit')")
    @Log(title = "设备监控", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TDeviceReportData tDeviceReportData)
    {
        return toAjax(tDeviceReportDataService.updateTDeviceReportData(tDeviceReportData));
    }

    /**
     * 删除设备监控
     */
    @PreAuthorize("@ss.hasPermi('dataMonitoring:reportData:remove')")
    @Log(title = "设备监控", businessType = BusinessType.DELETE)
	@DeleteMapping("/{deviceReportDataIds}")
    public AjaxResult remove(@PathVariable Long[] deviceReportDataIds)
    {
        return toAjax(tDeviceReportDataService.deleteTDeviceReportDataByIds(deviceReportDataIds));
    }
}
