package com.zehong.system.service.impl;

import com.github.pagehelper.PageInfo;
import com.zehong.common.core.domain.entity.SysDictData;
import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.StringUtils;
import com.zehong.system.domain.*;
import com.zehong.system.domain.form.InspectionPlanForm;
import com.zehong.system.domain.vo.InspectionDataVo;
import com.zehong.system.domain.vo.InspectionPlanVo;
import com.zehong.system.mapper.*;
import com.zehong.system.service.ISysDictTypeService;
import com.zehong.system.service.ITInspectionPlanService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 巡检计划Service业务层处理
 * 
 * @author zehong
 * @date 2021-07-21
 */
@Service
public class TInspectionPlanServiceImpl implements ITInspectionPlanService 
{
    @Autowired
    private TInspectionPlanMapper tInspectionPlanMapper;
    @Autowired
    private TInspectionDataMapper tInspectionDataMapper;
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private TWorkOrderMapper tWorkOrderMapper;
    @Autowired
    private TPipeMapper tPipeMapper;
    @Autowired
    private TDeviceInfoMapper tDeviceInfoMapper;
    @Autowired
    private ISysDictTypeService iSysDictTypeService;

    /**
     * 查询巡检计划
     * 
     * @param planId 巡检计划ID
     * @return 巡检计划
     */
    @Override
    public InspectionPlanVo selectTInspectionPlanById(int planId) throws Exception
    {
        InspectionPlanVo inspectionPlanVo = new InspectionPlanVo();
        TInspectionPlan tInspectionPlan = tInspectionPlanMapper.selectTInspectionPlanById(planId);
        BeanUtils.copyProperties(tInspectionPlan, inspectionPlanVo);

        if(tInspectionPlan.getOrderId() != null && !"".equals(tInspectionPlan.getOrderId())) {
            TWorkOrder tWorkOrder = tWorkOrderMapper.selectTWorkOrderById(tInspectionPlan.getOrderId());
            inspectionPlanVo.setAllotTime(tWorkOrder.getAllotTime());
            // 获取巡检员姓名
            SysUser appointInspector = sysUserMapper.selectUserById(tWorkOrder.getAppointInspector());
            inspectionPlanVo.setAppointInspectorName(appointInspector.getNickName());
        }

        List<TDeviceInfo> deviceInfoList = new ArrayList<>();
        List<TPipe> pipeList = new ArrayList<>();
        List<InspectionDataVo> inspectionDataList = new ArrayList<>();

        TInspectionData tInspectionData = new TInspectionData();
        tInspectionData.setPlanId(planId);
        List<TInspectionData> dataList = tInspectionDataMapper.selectTInspectionDataList(tInspectionData);

        if(dataList.size() != 0) {

            InspectionDataVo inspectionDataVo = new InspectionDataVo();
            TDeviceInfo deviceInfo = null;
            TPipe pipe = null;

            for (TInspectionData temp : dataList) {
                BeanUtils.copyProperties(temp, inspectionDataVo);

                if (!"0".equals(temp.getDeviceType())) {
                    deviceInfo = tDeviceInfoMapper.selectTDeviceInfoById(temp.getDeviceId());
                    if (deviceInfo != null) {
                        deviceInfoList.add(deviceInfo);

                        inspectionDataVo.setDeviceCode(deviceInfo.getDeviceCode());
                        inspectionDataVo.setDeviceName(deviceInfo.getDeviceName());
                    }
                } else {
                    pipe = tPipeMapper.selectTPipeById(temp.getDeviceId());
                    if (pipe != null) {
                        pipeList.add(pipe);

                        inspectionDataVo.setDeviceCode(pipe.getPipeCode());
                        inspectionDataVo.setDeviceName(pipe.getPipeName());
                    }
                }

                if (StringUtils.isNotEmpty(temp.getDeviceType())) {
                    List<SysDictData> sysDictDataList = iSysDictTypeService.selectDictDataByType("t_trouble_device_type");
                    for (SysDictData sysDictData : sysDictDataList) {
                        if (temp.getDeviceType().equals(sysDictData.getDictValue())) {
                            inspectionDataVo.setDeviceType(sysDictData.getDictLabel());
                        }
                    }
                }
                inspectionDataList.add(inspectionDataVo);
            }
        }

        inspectionPlanVo.setPipeList(pipeList);
        inspectionPlanVo.setDeviceList(deviceInfoList);
        inspectionPlanVo.setInspectionDataList(inspectionDataList);

        return inspectionPlanVo;
    }

    /**
     * 查询巡检计划列表
     * 
     * @param inspectionPlanForm 巡检计划
     * @return 巡检计划
     */
    @Override
    public List<TInspectionPlan> selectTInspectionPlanList(InspectionPlanForm inspectionPlanForm)
    {
        return tInspectionPlanMapper.selectTInspectionPlanList(inspectionPlanForm);
    }

    /**
     * 查询巡检计划列表
     *
     * @param inspectionPlanForm 巡检计划
     * @return 巡检计划
     */
    @Override
    public PageInfo<TInspectionPlan> selectTInspectionPlanPage(InspectionPlanForm inspectionPlanForm)
    {
        return new PageInfo(tInspectionPlanMapper.selectTInspectionPlanList(inspectionPlanForm));
    }

    /**
     * 新增巡检计划
     * 
     * @param tInspectionPlan 巡检计划
     * @return 结果
     */
    @Override
    public int insertTInspectionPlan(TInspectionPlan tInspectionPlan) throws Exception
    {
        tInspectionPlan.setPlanStatus("0");
        tInspectionPlan.setCreateTime(DateUtils.getNowDate());
        tInspectionPlanMapper.insertTInspectionPlan(tInspectionPlan);

        int planId = tInspectionPlan.getPlanId();
        String deviceIds = tInspectionPlan.getDeviceIds();
        String[] stringArr = deviceIds.split("],");
        String deviceType = null;

        for(int i = 0; i < stringArr.length; i++) {
            String[] temp = stringArr[i].split(",");

            for (int j = 0; j < temp.length; j++) {
                String regEx="[^0-9]";
                Pattern p = Pattern.compile(regEx);
                Matcher m = p.matcher(temp[j]);
//                System.out.println(m.replaceAll("").trim());

                if(j == 0) {
                    deviceType = m.replaceAll("").trim();
                } else {
                    Integer deviceId = Integer.valueOf(m.replaceAll("").trim());
                    TInspectionData data = new TInspectionData();
                    data.setPlanId(planId);
                    data.setDeviceId(deviceId);
                    data.setDeviceType(deviceType);
                    data.setCreateTime(DateUtils.getNowDate());

                    tInspectionDataMapper.insertTInspectionData(data);
                }
            }
        }
        return 1;
    }

    /**
     * 修改巡检计划
     *
     * @param tInspectionPlan 巡检计划
     * @return 结果
     */
    @Override
    public int updateTInspectionPlan(TInspectionPlan tInspectionPlan) throws Exception
    {
        tInspectionDataMapper.deleteTInspectionDataByPlanId(tInspectionPlan.getPlanId());

        String deviceIds = tInspectionPlan.getDeviceIds();
        String[] stringArr = deviceIds.split("],");
        String deviceType = null;

        for(int i = 0; i < stringArr.length; i++) {
            String[] temp = stringArr[i].split(",");

            for (int j = 0; j < temp.length; j++) {
                String regEx="[^0-9]";
                Pattern p = Pattern.compile(regEx);
                Matcher m = p.matcher(temp[j]);
//                System.out.println(m.replaceAll("").trim());

                if(j == 0) {
                    deviceType = m.replaceAll("").trim();
                } else {
                    Integer deviceId = Integer.valueOf(m.replaceAll("").trim());
                    TInspectionData data = new TInspectionData();
                    data.setPlanId(tInspectionPlan.getPlanId());
                    data.setDeviceId(deviceId);
                    data.setDeviceType(deviceType);
                    data.setCreateTime(DateUtils.getNowDate());

                    tInspectionDataMapper.insertTInspectionData(data);
                }
            }
        }

        tInspectionPlan.setUpdateTime(DateUtils.getNowDate());
        return tInspectionPlanMapper.updateTInspectionPlan(tInspectionPlan);
    }

    /**
     * 批量删除巡检计划
     * 
     * @param planIds 需要删除的巡检计划ID
     * @return 结果
     */
    @Override
    public int deleteTInspectionPlanByIds(int[] planIds)
    {
        return tInspectionPlanMapper.deleteTInspectionPlanByIds(planIds);
    }

    /**
     * 删除巡检计划信息
     * 
     * @param planId 巡检计划ID
     * @return 结果
     */
    @Override
    public int deleteTInspectionPlanById(int planId)
    {
        return tInspectionPlanMapper.deleteTInspectionPlanById(planId);
    }
}
