package com.zehong.system.service;

import java.util.List;

import com.github.pagehelper.PageInfo;
import com.zehong.system.domain.THiddenTrouble;
import com.zehong.system.domain.form.HiddenTroubleForm;
import com.zehong.system.domain.vo.HiddenTroubleVo;

/**
 * 隐患信息Service接口
 * 
 * @author zehong
 * @date 2021-07-21
 */
public interface ITHiddenTroubleService 
{
    /**
     * 查询隐患信息
     * 
     * @param troubleId 隐患信息ID
     * @return 隐患信息
     */
    public HiddenTroubleVo selectTHiddenTroubleById(int troubleId) throws Exception;

    /**
     * 查询隐患信息列表
     * 
     * @param hiddenTroubleForm 隐患信息
     * @return 隐患信息集合
     */
    public List<HiddenTroubleVo> selectTHiddenTroubleList(HiddenTroubleForm hiddenTroubleForm);


    /**
     * 查询隐患信息列表
     *
     * @param hiddenTroubleForm 隐患信息
     * @return 隐患信息集合
     */
    public PageInfo<HiddenTroubleVo> selectTHiddenTroublePage(HiddenTroubleForm hiddenTroubleForm);

    /**
     * 地图显示隐患信息列表
     *
     * @param
     * @return 隐患信息集合
     */
    public List<HiddenTroubleVo> getMapTHiddenTroubleList(String troubleName);

    /**
     * 新增隐患信息
     * 
     * @param tHiddenTrouble 隐患信息
     * @return 结果
     */
    public int insertTHiddenTrouble(THiddenTrouble tHiddenTrouble);

    /**
     * 修改隐患信息
     * 
     * @param tHiddenTrouble 隐患信息
     * @return 结果
     */
    public int updateTHiddenTrouble(THiddenTrouble tHiddenTrouble);

    /**
     * 批量删除隐患信息
     * 
     * @param troubleIds 需要删除的隐患信息ID
     * @return 结果
     */
    public int deleteTHiddenTroubleByIds(int[] troubleIds);

    /**
     * 删除隐患信息信息
     * 
     * @param troubleId 隐患信息ID
     * @return 结果
     */
    public int deleteTHiddenTroubleById(int troubleId);
}
