package com.zehong.system.service.impl;

import java.util.List;

import com.github.pagehelper.PageInfo;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.domain.form.DeviceReportDataForm;
import com.zehong.system.domain.vo.DeviceReportDataVo;
import com.zehong.system.mapper.TDeviceInfoMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TDeviceReportDataMapper;
import com.zehong.system.domain.TDeviceReportData;
import com.zehong.system.service.ITDeviceReportDataService;

/**
 * 设备监控Service业务层处理
 * 
 * @author zehong
 * @date 2021-08-09
 */
@Service
public class TDeviceReportDataServiceImpl implements ITDeviceReportDataService 
{
    @Autowired
    private TDeviceReportDataMapper tDeviceReportDataMapper;
    @Autowired
    private TDeviceInfoMapper tDeviceInfoMapper;

    /**
     * 查询设备监控
     * 
     * @param deviceId 设备ID
     * @return 设备监控
     */
    @Override
    public DeviceReportDataVo selectTDeviceReportDataByDeviceId(int deviceId) throws Exception
    {
        DeviceReportDataVo deviceReportDataVo = new DeviceReportDataVo();
        TDeviceInfo tDeviceInfo = tDeviceInfoMapper.selectTDeviceInfoById(deviceId);
        TDeviceReportData tDeviceReportData = tDeviceReportDataMapper.selectTDeviceReportDataByDeviceNum(tDeviceInfo.getIotNo());
        if(null != tDeviceReportData){
            BeanUtils.copyProperties(tDeviceReportData, deviceReportDataVo);
        }
        deviceReportDataVo.setDeviceId(tDeviceInfo.getDeviceId());
        deviceReportDataVo.setDeviceCode(tDeviceInfo.getDeviceCode());
        deviceReportDataVo.setDeviceName(tDeviceInfo.getDeviceName());
        deviceReportDataVo.setDeviceType(tDeviceInfo.getDeviceType());
        deviceReportDataVo.setDeviceModel(tDeviceInfo.getDeviceModel());
        deviceReportDataVo.setLongitude(tDeviceInfo.getLongitude());
        deviceReportDataVo.setLatitude(tDeviceInfo.getLatitude());

        // 查询当前设备两小时内的数据
        List<TDeviceReportData> deviceReportDataList = tDeviceReportDataMapper.getTDeviceReportDataList(tDeviceInfo.getIotNo());
        if(deviceReportDataList.size() != 0) {
            deviceReportDataVo.setDeviceReportDataList(deviceReportDataList);
        }

        return deviceReportDataVo;
    }

    /**
     * 查询设备监控列表
     * 
     * @param deviceReportDataForm 设备监控
     * @return 设备监控
     */
    @Override
    public List<DeviceReportDataVo> selectTDeviceReportDataList(DeviceReportDataForm deviceReportDataForm)
    {
        return tDeviceReportDataMapper.selectTDeviceReportDataList(deviceReportDataForm);
    }

    /**
     * 查询设备监控列表
     *
     * @param deviceReportDataForm 设备监控
     * @return 设备监控集合
     */
    public PageInfo<DeviceReportDataVo> selectTDeviceReportDataPage(DeviceReportDataForm deviceReportDataForm){
        return new PageInfo(tDeviceReportDataMapper.selectTDeviceReportDataList(deviceReportDataForm));
    }

    /**
     * 查询设备监控实时数据
     *
     * @param deviceReportDataForm 设备监控
     * @return 设备监控
     */
    @Override
    public List<DeviceReportDataVo> selectRealtimeDataList(DeviceReportDataForm deviceReportDataForm)
    {
        return tDeviceReportDataMapper.selectRealtimeDataList(deviceReportDataForm);
    }

    /**
     * 查询设备监控实时数据
     *
     * @param deviceReportDataForm 设备监控
     * @return 设备监控
     */
    @Override
    public PageInfo<DeviceReportDataVo> selectRealtimeDataPage(DeviceReportDataForm deviceReportDataForm)
    {
        return new PageInfo(tDeviceReportDataMapper.selectRealtimeDataList(deviceReportDataForm));
    }

    /**
     * 新增设备监控
     * 
     * @param tDeviceReportData 设备监控
     * @return 结果
     */
    @Override
    public int insertTDeviceReportData(TDeviceReportData tDeviceReportData)
    {
        tDeviceReportData.setCreateTime(DateUtils.getNowDate());
        return tDeviceReportDataMapper.insertTDeviceReportData(tDeviceReportData);
    }

    /**
     * 修改设备监控
     * 
     * @param tDeviceReportData 设备监控
     * @return 结果
     */
    @Override
    public int updateTDeviceReportData(TDeviceReportData tDeviceReportData)
    {
        tDeviceReportData.setUpdateTime(DateUtils.getNowDate());
        return tDeviceReportDataMapper.updateTDeviceReportData(tDeviceReportData);
    }

    /**
     * 批量删除设备监控
     * 
     * @param deviceReportDataIds 需要删除的设备监控ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceReportDataByIds(Long[] deviceReportDataIds)
    {
        return tDeviceReportDataMapper.deleteTDeviceReportDataByIds(deviceReportDataIds);
    }

    /**
     * 删除设备监控信息
     * 
     * @param deviceReportDataId 设备监控ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceReportDataById(Long deviceReportDataId)
    {
        return tDeviceReportDataMapper.deleteTDeviceReportDataById(deviceReportDataId);
    }
}
