package com.zehong.web.controller.device;

import com.github.pagehelper.PageInfo;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TPipe;
import com.zehong.system.domain.vo.PipeVo;
import com.zehong.system.service.ITPipeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 管道信息Controller
 * 
 * @author zehong
 * @date 2021-07-08
 */
@RestController
@RequestMapping("/device/pipe")
public class TPipeController extends BaseController
{
    @Autowired
    private ITPipeService tPipeService;

    /**
     * 查询管道信息列表
     */
    @PreAuthorize("@ss.hasPermi('device:pipe:list')")
    @GetMapping("/list")
    public TableDataInfo list(TPipe tPipe)
    {
        startPage();
        PageInfo<PipeVo> page = tPipeService.selectTPipePage(tPipe);
        return getDataTable(page);
    }


    @GetMapping("/pipeAllInfoList")
    public AjaxResult pipeAllInfoList(TPipe tPipe)
    {
        List<PipeVo> list = tPipeService.selectTPipeList(tPipe);
        return AjaxResult.success(list);
    }

    /**
     * 导出管道信息列表
     */
    @PreAuthorize("@ss.hasPermi('device:pipe:export')")
    @Log(title = "管道信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TPipe tPipe)
    {
        List<PipeVo> list = tPipeService.selectTPipeList(tPipe);
        ExcelUtil<PipeVo> util = new ExcelUtil<PipeVo>(PipeVo.class);
        return util.exportExcel(list, "管道信息数据");
    }

    /**
     * 获取管道信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('device:pipe:query')")
    @GetMapping(value = "/{pipeId}")
    public AjaxResult getInfo(@PathVariable("pipeId") int pipeId)
    {
        return AjaxResult.success(tPipeService.selectTPipeById(pipeId));
    }

    /**
     * 新增管道信息
     */
    @PreAuthorize("@ss.hasPermi('device:pipe:add')")
    @Log(title = "管道信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TPipe tPipe)
    {
        int result = tPipeService.insertTPipe(tPipe);
        if(result<=0){
            new Exception("管道信息插入失败");
        }
        return AjaxResult.success(tPipe.getPipeId());
    }

    /**
     * 修改管道信息
     */
    @PreAuthorize("@ss.hasPermi('device:pipe:edit')")
    @Log(title = "管道信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TPipe tPipe)
    {
        return toAjax(tPipeService.updateTPipe(tPipe));
    }

    /**
     * 删除管道信息
     */
    @PreAuthorize("@ss.hasPermi('device:pipe:remove')")
    @Log(title = "管道信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{pipeIds}")
    public AjaxResult remove(@PathVariable int[] pipeIds)
    {
        return toAjax(tPipeService.deleteTPipeByIds(pipeIds));
    }

    /**
     * 统计管道总长度
     */
    //@PreAuthorize("@ss.hasPermi('device:pipe:countPipeLength')")
    @GetMapping("/countPipeLength")
    public AjaxResult countPipeLength()
    {
        return AjaxResult.success(tPipeService.countPipeLength());
    }
}
