package com.zehong.system.service;

import java.util.List;
import java.util.Map;

import com.github.pagehelper.PageInfo;

import com.github.pagehelper.PageInfo;
import com.zehong.system.domain.TWorkOrder;
import com.zehong.system.domain.form.TWorkOrderForm;
import com.zehong.system.domain.vo.WorkOrderVo;
import org.apache.commons.math3.analysis.function.Add;
import org.apache.poi.ss.formula.functions.T;

/**
 * 工单基础信息Service接口
 * 
 * @author zehong
 * @date 2021-07-19
 */
public interface ITWorkOrderService 
{

    /**
     * 查询工单基础信息
     * 
     * @param orderId 工单基础信息ID
     * @return 工单基础信息
     */
    public WorkOrderVo selectTWorkOrderById(String orderId) throws Exception;

    /**
     * 查询工单基础信息列表
     * 
     * @param tWorkOrderForm 工单基础信息表单
     * @return 工单基础信息集合
     */
    public List<WorkOrderVo> selectTWorkOrderList(TWorkOrderForm tWorkOrderForm) throws Exception;

    /**
     * 查询工单基础信息列表
     *
     * @param tWorkOrderForm 工单基础信息表单
     * @return 工单基础信息集合
     */
    public PageInfo<WorkOrderVo> selectTWorkOrderPage(TWorkOrderForm tWorkOrderForm) throws Exception;

    /**
     * 查询代办订单
     * @return
     * @throws Exception
     */
    public PageInfo<TWorkOrder> selectWaitingWorkOrder(String userId,Integer type,String searchStr)throws Exception;

    /**
     * 新增工单基础信息
     * 
     * @param tWorkOrder 工单基础信息
     * @return 结果
     */
    public String insertTWorkOrder(TWorkOrder tWorkOrder) throws Exception;

    /**
     * 修改工单基础信息
     * 
     * @param tWorkOrder 工单基础信息
     * @return 结果
     */
    public int updateTWorkOrder(TWorkOrder tWorkOrder) throws Exception;

    /**
     * 批量删除工单基础信息
     * 
     * @param orderIds 需要删除的工单基础信息ID
     * @return 结果
     */
    public int deleteTWorkOrderByIds(String[] orderIds);

    /**
     * 删除工单基础信息信息
     * 
     * @param orderId 工单基础信息ID
     * @return 结果
     */
    public int deleteTWorkOrderById(String orderId);

    /**
     * 小程序订单详情
     * @param orderId
     * @return
     */
    public TWorkOrder orderDtail(String orderId);
}
