package com.zehong.system.domain.form;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.core.domain.BaseEntity;

import java.util.Date;

/**
 * 巡检计划对象 t_inspection_plan
 * 
 * @author zehong
 * @date 2021-07-21
 */
public class InspectionPlanForm extends BaseEntity
{
    /** 巡检计划名称 */
    private String planName;

    /** 工单id */
    private String orderId;

    /** 起始开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime1;

    /** 起始结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime1;

    /** 截止开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime2;

    /** 截止结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime2;

    /** 计划状态（0未下发，1已下发，2进行中，3已完成） */
    private String planStatus;

    /** 计划描述 */
    private String remarks;

    public void setPlanName(String planName) 
    {
        this.planName = planName;
    }

    public String getPlanName() 
    {
        return planName;
    }

    public void setOrderId(String orderId)
    {
        this.orderId = orderId;
    }

    public String getOrderId() 
    {
        return orderId;
    }

    public void setStartTime1(Date startTime1)
    {
        this.startTime1 = startTime1;
    }

    public Date getStartTime1()
    {
        return startTime1;
    }

    public void setEndTime1(Date endTime1)
    {
        this.endTime1 = endTime1;
    }

    public Date getEndTime1()
    {
        return endTime1;
    }

    public void setPlanStatus(String planStatus) 
    {
        this.planStatus = planStatus;
    }

    public String getPlanStatus() 
    {
        return planStatus;
    }

    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

}
