package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 巡检记录对象 t_inspection_data
 * 
 * @author zehong
 * @date 2021-07-21
 */
public class TInspectionData extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 巡检记录id */
    private Integer dataId;

    /** 巡检计划id */
    @Excel(name = "巡检计划id")
    private Integer planId;

    /** 设备id */
    @Excel(name = "设备id")
    private Integer deviceId;

    /** 设备类型（0管道，1调压阀，2阀门井，3流量计，4压力表） */
    @Excel(name = "设备类型（0管道，1调压阀，2阀门井，3流量计，4压力表）")
    private String deviceType;

    /** 处理状态（1不需处理，2已处理完成，3未处理完成） */
    @Excel(name = "处理状态", readConverterExp = "1不需处理，2已处理完成，3未处理完成")
    private String dealStatus;

    /** 是否存在隐患 */
    @Excel(name = "是否存在隐患")
    private String isHiddenDanger;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setDataId(Integer dataId)
    {
        this.dataId = dataId;
    }

    public Integer getDataId()
    {
        return dataId;
    }

    public void setPlanId(Integer planId)
    {
        this.planId = planId;
    }

    public Integer getPlanId()
    {
        return planId;
    }

    public void setDeviceId(Integer deviceId)
    {
        this.deviceId = deviceId;
    }

    public Integer getDeviceId()
    {
        return deviceId;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setDealStatus(String dealStatus)
    {
        this.dealStatus = dealStatus;
    }

    public String getDealStatus() 
    {
        return dealStatus;
    }

    public String getIsHiddenDanger() {
        return isHiddenDanger;
    }

    public void setIsHiddenDanger(String isHiddenDanger) {
        this.isHiddenDanger = isHiddenDanger;
    }

    public void setRemarks(String remarks)
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("dataId", getDataId())
            .append("planId", getPlanId())
            .append("deviceId", getDeviceId())
            .append("deviceType", getDeviceType())
            .append("dealStatus", getDealStatus())
            .append("isHiddenDanger", getIsHiddenDanger())
            .append("updateTime", getUpdateTime())
            .append("createTime", getCreateTime())
            .append("remarks", getRemarks())
            .toString();
    }
}
