package com.zehong.web.controller.device;

import java.util.List;

import com.github.pagehelper.PageInfo;
import com.zehong.system.domain.form.RelationTMonitorDevice;
import com.zehong.system.domain.form.TMonitorDeviceFrom;
import com.zehong.system.service.ITDeviceInfoService;
import com.zehong.system.service.impl.TPipeServiceImpl;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TMonitorDevice;
import com.zehong.system.service.ITMonitorDeviceService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 设备监控Controller
 * 
 * @author zehong
 * @date 2021-08-05
 */
@RestController
@RequestMapping("/system/device")
public class TMonitorDeviceController extends BaseController
{
    @Autowired
    private ITMonitorDeviceService tMonitorDeviceService;

    @Autowired
    private ITDeviceInfoService itDeviceInfoService;

    @Autowired
    private TPipeServiceImpl tPipeService;

    /**
     * 查询设备监控列表
     */
    @PreAuthorize("@ss.hasPermi('system:device:list')")
    @GetMapping("/list")
    public TableDataInfo list(TMonitorDevice tMonitorDevice)
    {
        startPage();
        PageInfo<TMonitorDevice> page = tMonitorDeviceService.selectTMonitorDevicePage(tMonitorDevice);
        for(TMonitorDevice device: page.getList()){
            device.setDeviceName(itDeviceInfoService.selectTDeviceInfoById(device.getDeviceId().intValue()).getDeviceName());
            device.setRelationDeviceName(itDeviceInfoService.selectTDeviceInfoById(device.getRelationDeviceId().intValue()).getDeviceName());
            device.setRelationPipeName(tPipeService.selectTPipeById(device.getRelationPipeId().intValue()).getPipeName());
        }
        return getDataTable(page);
    }

    /**
     * 导出设备监控列表
     */
    @PreAuthorize("@ss.hasPermi('system:device:export')")
    @Log(title = "设备监控", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TMonitorDevice tMonitorDevice)
    {
        List<TMonitorDevice> list = tMonitorDeviceService.selectTMonitorDeviceList(tMonitorDevice);
        ExcelUtil<TMonitorDevice> util = new ExcelUtil<TMonitorDevice>(TMonitorDevice.class);
        return util.exportExcel(list, "设备监控数据");
    }

    /**
     * 获取设备监控详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:device:query')")
    @GetMapping(value = "/{monitorId}")
    public AjaxResult getInfo(@PathVariable("monitorId") Long monitorId)
    {
        return AjaxResult.success(tMonitorDeviceService.selectTMonitorDeviceById(monitorId));
    }

    /**
     * 新增设备监控
     */
    @PreAuthorize("@ss.hasPermi('system:device:add')")
    @Log(title = "设备监控", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TMonitorDevice tMonitorDevice)
    {
        return toAjax(tMonitorDeviceService.insertTMonitorDevice(tMonitorDevice));
    }

    @PostMapping("/batchAdd")
    public AjaxResult batchAdd(@RequestBody TMonitorDeviceFrom tMonitorDeviceFrom){

        for(RelationTMonitorDevice relationTMonitorDevice : tMonitorDeviceFrom.getRelationDevices()){
            TMonitorDevice tMonitorDevice = new TMonitorDevice();
            tMonitorDevice.setDeviceId(tMonitorDeviceFrom.getDeviceId());
            tMonitorDevice.setDeviceThreshold(tMonitorDeviceFrom.getDeviceThreshold());
            tMonitorDevice.setRelationDeviceId(relationTMonitorDevice.getRelationDeviceId());
            tMonitorDevice.setRelationDeviceThreshold(relationTMonitorDevice.getRelationDeviceThreshold());
            tMonitorDevice.setRelationPipeId(relationTMonitorDevice.getRelationPipeId());
            tMonitorDevice.setRelationPipeThreshold(relationTMonitorDevice.getRelationPipeThreshold());
            tMonitorDeviceService.insertTMonitorDevice(tMonitorDevice);
        }
        return AjaxResult.success();
    }

    /**
     * 修改设备监控
     */
    @PreAuthorize("@ss.hasPermi('system:device:edit')")
    @Log(title = "设备监控", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TMonitorDevice tMonitorDevice)
    {
        return toAjax(tMonitorDeviceService.updateTMonitorDevice(tMonitorDevice));
    }

    /**
     * 删除设备监控
     */
    @PreAuthorize("@ss.hasPermi('system:device:remove')")
    @Log(title = "设备监控", businessType = BusinessType.DELETE)
	@DeleteMapping("/{monitorIds}")
    public AjaxResult remove(@PathVariable Long[] monitorIds)
    {
        return toAjax(tMonitorDeviceService.deleteTMonitorDeviceByIds(monitorIds));
    }
}
