package com.zehong.system.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.core.domain.BaseEntity;
import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.domain.TPipe;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 工单基础信息对象 t_work_order
 * 
 * @author zehong
 * @date 2021-07-19
 */
public class WorkOrderVo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 工单id */
    private String orderId;

    /** 工单类型（1巡检信息，2隐患信息，3报警信息） */
    private String orderType;

    /** 源id */
    private Integer resourceId;

    /** 工单名称 */
    private String orderName;

    /** 设备名称 */
    private String deviceName;

    /** 设备类型 */
    private String deviceType;

    /** 设备列表 */
    private List<TDeviceInfo> deviceInfoList;

    /** 管道列表 */
    private List<TPipe> pipeList;

    /** 反馈信息列表 */
    private List<OrderFeedbackVo> feedbackList;

    /** 设备数量 */
    private int deviceNum;

    /** 完成数量 */
    private int finishNum;

    /** 工单状态（0未接收，1已接收，2进行中，3已反馈，4已归档） */
    private String orderStatus;

    /** 指定执行人员（巡检员id） */
    private Long appointInspector;

    /** 指定执行人员姓名 */
    private String appointInspectorName;

    /** 下发时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date allotTime;

    /** 实际接收人员（巡检员id） */
    private Long actualInspector;

    /** 实际接收人员姓名 */
    private String actualInspectorName;

    /** 实际接收时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date actualTime;

    /** 归档信息 */
    private String archiving;

    /** 备注 */
    private String remarks;

    public void setOrderId(String orderId)
    {
        this.orderId = orderId;
    }

    public String getOrderId() 
    {
        return orderId;
    }
    public void setOrderType(String orderType) 
    {
        this.orderType = orderType;
    }

    public String getOrderType() 
    {
        return orderType;
    }

    public Integer getResourceId() {
        return resourceId;
    }

    public void setResourceId(Integer resourceId) {
        this.resourceId = resourceId;
    }

    public void setOrderName(String orderName)
    {
        this.orderName = orderName;
    }

    public String getOrderName() 
    {
        return orderName;
    }

    public String getDeviceName() {
        return deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public List<TDeviceInfo> getDeviceInfoList() {
        return deviceInfoList;
    }

    public void setDeviceInfoList(List<TDeviceInfo> deviceInfoList) {
        this.deviceInfoList = deviceInfoList;
    }

    public List<TPipe> getPipeList() {
        return pipeList;
    }

    public void setPipeList(List<TPipe> pipeList) {
        this.pipeList = pipeList;
    }

    public List<OrderFeedbackVo> getFeedbackList() {
        return feedbackList;
    }

    public void setFeedbackList(List<OrderFeedbackVo> feedbackList) {
        this.feedbackList = feedbackList;
    }

    public int getDeviceNum() {
        return deviceNum;
    }

    public void setDeviceNum(int deviceNum) {
        this.deviceNum = deviceNum;
    }

    public int getFinishNum() {
        return finishNum;
    }

    public void setFinishNum(int finishNum) {
        this.finishNum = finishNum;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setOrderStatus(String orderStatus)
    {
        this.orderStatus = orderStatus;
    }

    public String getOrderStatus() 
    {
        return orderStatus;
    }

    public void setAppointInspector(Long appointInspector)
    {
        this.appointInspector = appointInspector;
    }

    public Long getAppointInspector()
    {
        return appointInspector;
    }

    public void setAllotTime(Date allotTime) 
    {
        this.allotTime = allotTime;
    }

    public Date getAllotTime() 
    {
        return allotTime;
    }

    public void setActualInspector(Long actualInspector)
    {
        this.actualInspector = actualInspector;
    }

    public Long getActualInspector()
    {
        return actualInspector;
    }

    public void setActualTime(Date actualTime) 
    {
        this.actualTime = actualTime;
    }

    public Date getActualTime() 
    {
        return actualTime;
    }

    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    public String getArchiving() {
        return archiving;
    }

    public void setArchiving(String archiving) {
        this.archiving = archiving;
    }

    public String getAppointInspectorName() {
        return appointInspectorName;
    }

    public void setAppointInspectorName(String appointInspectorName) {
        this.appointInspectorName = appointInspectorName;
    }

    public String getActualInspectorName() {
        return actualInspectorName;
    }

    public void setActualInspectorName(String actualInspectorName) {
        this.actualInspectorName = actualInspectorName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("orderId", getOrderId())
            .append("orderType", getOrderType())
            .append("resourceId", getResourceId())
            .append("orderName", getOrderName())
            .append("deviceNum", getDeviceNum())
            .append("finishNum", getFinishNum())
            .append("deviceType", getDeviceType())
            .append("orderStatus", getOrderStatus())
            .append("createTime", getCreateTime())
            .append("appointInspector", getAppointInspector())
            .append("appointInspectorName", getAppointInspectorName())
            .append("allotTime", getAllotTime())
            .append("actualInspector", getActualInspector())
            .append("actualInspectorName", getActualInspectorName())
            .append("actualTime", getActualTime())
            .append("remarks", getRemarks())
            .toString();
    }
}
