package com.zehong.system.service.impl;

import java.util.ArrayList;
import java.util.List;

import com.zehong.common.core.domain.entity.SysDictData;
import com.zehong.common.utils.StringUtils;
import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.domain.vo.PipeVo;
import com.zehong.system.mapper.TDeviceInfoMapper;
import com.zehong.system.service.ISysDictTypeService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TPipeMapper;
import com.zehong.system.domain.TPipe;
import com.zehong.system.service.ITPipeService;

/**
 * 管道信息Service业务层处理
 * 
 * @author zehong
 * @date 2021-07-08
 */
@Service
public class TPipeServiceImpl implements ITPipeService 
{
    @Autowired
    private TPipeMapper tPipeMapper;
    @Autowired
    private TDeviceInfoMapper tDeviceInfoMapper;
    /**
     * 查询管道信息
     * 
     * @param pipeId 管道信息ID
     * @return 管道信息
     */
    @Override
    public PipeVo selectTPipeById(int pipeId)
    {
        PipeVo pipeVo = new PipeVo();
        TPipe tPipe = tPipeMapper.selectTPipeById(pipeId);
        BeanUtils.copyProperties(tPipe, pipeVo);

        List<TDeviceInfo> deviceInfoList = tDeviceInfoMapper.selectTDeviceInfoByPipeId(tPipe.getPipeId());
        if(deviceInfoList.size() != 0) {
            pipeVo.setDeviceInfoList(deviceInfoList);
        }

        return pipeVo;
    }

    /**
     * 查询管道信息列表
     * 
     * @param tPipe 管道信息
     * @return 管道信息
     */
    @Override
    public List<PipeVo> selectTPipeList(TPipe tPipe)
    {
        List<PipeVo> list = new ArrayList<>();
        List<TPipe> tPipeList = tPipeMapper.selectTPipeList(tPipe);

        if(tPipeList.size() != 0){

            for(TPipe pipe : tPipeList){
                PipeVo pipeVo = new PipeVo();
                BeanUtils.copyProperties(pipe, pipeVo);

                List<TDeviceInfo> deviceInfoList = tDeviceInfoMapper.selectTDeviceInfoByPipeId(pipe.getPipeId());
                if(deviceInfoList.size() != 0) {
                    pipeVo.setDeviceInfoList(deviceInfoList);
                }

                list.add(pipeVo);
            }
        }
        return list;
    }

    /**
     * 统计管道总长度
     * @return
     */
    @Override
    public double countPipeLength() {
        return tPipeMapper.countPipeLength();
    };

    /**
     * 新增管道信息
     * 
     * @param tPipe 管道信息
     * @return 结果
     */
    @Override
    public int insertTPipe(TPipe tPipe)
    {
        return tPipeMapper.insertTPipe(tPipe);
    }

    /**
     * 修改管道信息
     * 
     * @param tPipe 管道信息
     * @return 结果
     */
    @Override
    public int updateTPipe(TPipe tPipe)
    {
        if("1".equals(tPipe.getIsDel())){
            List<TDeviceInfo> tDeviceInfoList = tDeviceInfoMapper.selectTDeviceInfoByPipeId(tPipe.getPipeId());

            if(tDeviceInfoList.size() != 0) {
                for (TDeviceInfo device : tDeviceInfoList) {
                    device.setIsDel("1");
                    tDeviceInfoMapper.updateTDeviceInfo(device);
                }
            }
        }
        return tPipeMapper.updateTPipe(tPipe);
    }

    /**
     * 批量删除管道信息
     * 
     * @param pipeIds 需要删除的管道信息ID
     * @return 结果
     */
    @Override
    public int deleteTPipeByIds(int[] pipeIds)
    {
        return tPipeMapper.deleteTPipeByIds(pipeIds);
    }

    /**
     * 删除管道信息信息
     * 
     * @param pipeId 管道信息ID
     * @return 结果
     */
    @Override
    public int deleteTPipeById(int pipeId)
    {
        return tPipeMapper.deleteTPipeById(pipeId);
    }
}
