package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TEnterpriseInfoMapper;
import com.zehong.system.domain.TEnterpriseInfo;
import com.zehong.system.service.ITEnterpriseInfoService;

/**
 * 企业基本信息Service业务层处理
 * 
 * @author zehong
 * @date 2021-06-30
 */
@Service
public class TEnterpriseInfoServiceImpl implements ITEnterpriseInfoService 
{
    @Autowired
    private TEnterpriseInfoMapper tEnterpriseInfoMapper;

    /**
     * 查询企业基本信息
     * 
     * @param infoId 企业基本信息ID
     * @return 企业基本信息
     */
    @Override
    public TEnterpriseInfo selectTEnterpriseInfoById(int infoId)
    {
        return tEnterpriseInfoMapper.selectTEnterpriseInfoById(infoId);
    }

    /**
     * 查询企业基本信息列表
     * 
     * @param tEnterpriseInfo 企业基本信息
     * @return 企业基本信息
     */
    @Override
    public List<TEnterpriseInfo> selectTEnterpriseInfoList(TEnterpriseInfo tEnterpriseInfo)
    {
        return tEnterpriseInfoMapper.selectTEnterpriseInfoList(tEnterpriseInfo);
    }

    /**
     * 新增企业基本信息
     * 
     * @param tEnterpriseInfo 企业基本信息
     * @return 结果
     */
    @Override
    public int insertTEnterpriseInfo(TEnterpriseInfo tEnterpriseInfo)
    {
        tEnterpriseInfo.setCreateTime(DateUtils.getNowDate());
        return tEnterpriseInfoMapper.insertTEnterpriseInfo(tEnterpriseInfo);
    }

    /**
     * 修改企业基本信息
     * 
     * @param tEnterpriseInfo 企业基本信息
     * @return 结果
     */
    @Override
    public int updateTEnterpriseInfo(TEnterpriseInfo tEnterpriseInfo)
    {
        tEnterpriseInfo.setUpdateTime(DateUtils.getNowDate());
        return tEnterpriseInfoMapper.updateTEnterpriseInfo(tEnterpriseInfo);
    }

    /**
     * 批量删除企业基本信息
     * 
     * @param infoIds 需要删除的企业基本信息ID
     * @return 结果
     */
    @Override
    public int deleteTEnterpriseInfoByIds(int[] infoIds)
    {
        return tEnterpriseInfoMapper.deleteTEnterpriseInfoByIds(infoIds);
    }

    /**
     * 删除企业基本信息信息
     * 
     * @param infoId 企业基本信息ID
     * @return 结果
     */
    @Override
    public int deleteTEnterpriseInfoById(int infoId)
    {
        return tEnterpriseInfoMapper.deleteTEnterpriseInfoById(infoId);
    }
}
