package com.zehong.system.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import com.zehong.system.domain.TDeviceInfo;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;
import java.util.List;

/**
 * 管道信息对象 t_pipe
 * 
 * @author zehong
 * @date 2021-07-08
 */
public class PipeVo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 管道id */
    private Integer pipeId;

    /** 企业id */
    @Excel(name = "企业id")
    private Integer enterpriseId;

    /** 管道名称 */
    @Excel(name = "管道名称")
    private String pipeName;

    /** 管道编号 */
    @Excel(name = "管道编号")
    private String pipeCode;

    /** 设备列表 */
    private List<TDeviceInfo> deviceInfoList;

    /** 管道所在地址 */
    @Excel(name = "管道所在地址")
    private String pipeAddr;

    /** 坐标 */
    @Excel(name = "坐标")
    private String coordinates;

    /** 管道长度 */
    @Excel(name = "管道长度")
    private double pipeLength;

    /** 管道类型（1地埋管线、2地表管线） */
    @Excel(name = "管道类型", readConverterExp = "1地埋管线、2地表管线")
    private String pipeType;

    /** 管道压力（低压，中压，次高压，高压） */
    @Excel(name = "管道压力", readConverterExp = "1低压，2中压，3次高压，4高压")
    private String pipePressure;

    /** 设备图片路径 */
    @Excel(name = "设备图片路径")
    private String iconUrl;

    /** 安装时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "安装时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date installationTime;

    /** 最后巡检时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "最后巡检时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date inspectionTime;

    /** 是否删除 */
    @Excel(name = "是否删除")
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setPipeId(Integer pipeId)
    {
        this.pipeId = pipeId;
    }

    public Integer getPipeId()
    {
        return pipeId;
    }
    public void setEnterpriseId(Integer enterpriseId)
    {
        this.enterpriseId = enterpriseId;
    }

    public Integer getEnterpriseId()
    {
        return enterpriseId;
    }
    public void setPipeName(String pipeName) 
    {
        this.pipeName = pipeName;
    }

    public String getPipeName() 
    {
        return pipeName;
    }

    public String getPipeCode() {
        return pipeCode;
    }

    public void setPipeCode(String pipeCode) {
        this.pipeCode = pipeCode;
    }

    public List<TDeviceInfo> getDeviceInfoList() {
        return deviceInfoList;
    }

    public void setDeviceInfoList(List<TDeviceInfo> deviceInfoList) {
        this.deviceInfoList = deviceInfoList;
    }

    public void setPipeAddr(String pipeAddr)
    {
        this.pipeAddr = pipeAddr;
    }

    public String getPipeAddr() 
    {
        return pipeAddr;
    }
    public void setCoordinates(String coordinates) 
    {
        this.coordinates = coordinates;
    }

    public String getCoordinates() 
    {
        return coordinates;
    }
    public void setPipeLength(double pipeLength)
    {
        this.pipeLength = pipeLength;
    }

    public double getPipeLength()
    {
        return pipeLength;
    }
    public void setPipeType(String pipeType) 
    {
        this.pipeType = pipeType;
    }

    public String getPipeType() 
    {
        return pipeType;
    }
    public void setPipePressure(String pipePressure) 
    {
        this.pipePressure = pipePressure;
    }

    public String getPipePressure() 
    {
        return pipePressure;
    }
    public void setIconUrl(String iconUrl) 
    {
        this.iconUrl = iconUrl;
    }

    public String getIconUrl() 
    {
        return iconUrl;
    }
    public void setInstallationTime(Date installationTime) 
    {
        this.installationTime = installationTime;
    }

    public Date getInstallationTime() 
    {
        return installationTime;
    }
    public void setInspectionTime(Date inspectionTime) 
    {
        this.inspectionTime = inspectionTime;
    }

    public Date getInspectionTime() 
    {
        return inspectionTime;
    }

    public String getIsDel() {
        return isDel;
    }

    public void setIsDel(String isDel) {
        this.isDel = isDel;
    }

    public void setRemarks(String remarks)
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }
}
